/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.generator.errors.messageflow;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.mule.tooling.core.generator.errors.IMuleError;

public class XMLMuleError
implements IMuleError {
    private int lineNumber;
    private int charStart;
    private int charEnd;
    private int severity;
    private String message;
    private IResource resource;
    private String entityName;
    private IMessage imessage;
    private String validatorId;
    private boolean visibleInProblemsPane;
    private String markerType;

    public XMLMuleError(IResource resource, String entityName, String localizedMessage, IMessage message, int severity, String validatorId, String markerType) {
        this.resource = resource;
        this.entityName = entityName;
        this.message = localizedMessage;
        this.validatorId = validatorId;
        this.markerType = markerType;
        this.lineNumber = message.getLineNumber();
        this.charStart = message.getOffset();
        this.charEnd = message.getLength() + message.getOffset();
        this.severity = severity;
        this.imessage = message;
    }

    @Override
    public void createMarker() throws CoreException {
        IMarker createMarker = this.resource.createMarker(this.markerType);
        createMarker.setAttribute("lineNumber", this.lineNumber);
        createMarker.setAttribute("charStart", this.charStart);
        createMarker.setAttribute("charEnd", this.charEnd);
        createMarker.setAttribute("severity", this.severity);
        createMarker.setAttribute("location", (Object)this.entityName);
        createMarker.setAttribute("message", (Object)this.message);
        createMarker.setAttribute("org.mule.tooling.validator.id", (Object)this.validatorId);
    }

    public IMessage getIMessage() {
        return this.imessage;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getCharStart() {
        return this.charStart;
    }

    public int getCharEnd() {
        return this.charEnd;
    }

    public int getSeverity() {
        return this.severity;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public IResource getResource() {
        return this.resource;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getValidatorId() {
        return this.validatorId;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getEntityName());
        sb.append(" (line " + this.getLineNumber() + ") ");
        sb.append(" -> " + this.getMessage());
        return sb.toString();
    }

    public void setVisibleInProblemsPane() {
        this.visibleInProblemsPane = true;
    }

    public boolean isVisibleInProblemsPane() {
        return this.visibleInProblemsPane;
    }
}

