/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.generator.errors.messageflow;

import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.mule.tooling.core.generator.errors.IMuleError;
import org.mule.tooling.core.generator.errors.messageflow.MessageFlowEntityError;
import org.mule.tooling.core.generator.errors.messageflow.XMLMuleError;

public class MuleErrorFactory {
    public static Optional<MessageFlowEntityError> createMessageFlowErrorIfMarkerMatches(IMarker marker) {
        try {
            if ("org.mule.tooling.core.messageFlowError".equals(marker.getType())) {
                MessageFlowEntityError error = MuleErrorFactory.createMessageFlowErrorFromMarker(marker, marker.getResource());
                return Optional.of(error);
            }
            return Optional.empty();
        }
        catch (CoreException coreException) {
            return Optional.empty();
        }
    }

    public static MessageFlowEntityError createMessageFlowErrorFromMarker(IMarker marker, IResource resource) {
        MessageFlowEntityError error = new MessageFlowEntityError(resource);
        error.setPath(marker.getAttribute("org.mule.tooling.entity.id", null));
        error.setEntityName(marker.getAttribute("location", null));
        error.setMessage(marker.getAttribute("message", null));
        error.setSeverity(marker.getAttribute("severity", 0));
        return error;
    }

    public static IMuleError createMessageFlowError(IResource resource, String path, String entityName, String message, int severity, String validatorId) {
        MessageFlowEntityError error = new MessageFlowEntityError(resource);
        error.setEntityName(entityName);
        error.setMessage(message);
        error.setSeverity(severity);
        error.setPath(path);
        error.setValidatorId(validatorId);
        return error;
    }

    public static IMuleError createXMLSyntaxMuleError(IResource resource, String entityName, String localizedMessage, IMessage message, int severity, String validatorId) {
        XMLMuleError xmlMuleError = new XMLMuleError(resource, entityName, localizedMessage, message, severity, validatorId, "org.mule.tooling.core.xmlSyntaxError");
        xmlMuleError.setVisibleInProblemsPane();
        return xmlMuleError;
    }

    public static IMuleError createXMLMuleError(IResource resource, String entityName, String localizedMessage, IMessage message, int severity, String validatorId) {
        XMLMuleError xmlMuleError = new XMLMuleError(resource, entityName, localizedMessage, message, severity, validatorId, "org.mule.tooling.core.muleXMLError");
        return xmlMuleError;
    }

    public static IMuleError createXMLMuleErrorVisibleInProblemsPane(IResource resource, String entityName, String localizedMessage, IMessage message, int severity, String validatorId) {
        XMLMuleError xmlMuleError = new XMLMuleError(resource, entityName, localizedMessage, message, severity, validatorId, "org.mule.tooling.core.muleXMLError");
        xmlMuleError.setVisibleInProblemsPane();
        return xmlMuleError;
    }

    public static MessageFlowEntityError[] createMessageFlowErrorFromMarkers(IMarker[] markers, IFile resource) {
        MessageFlowEntityError[] result = new MessageFlowEntityError[markers.length];
        int i = 0;
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            result[i] = MuleErrorFactory.createMessageFlowErrorFromMarker(marker, (IResource)resource);
            ++i;
            ++n2;
        }
        return result;
    }
}

