/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.externalNames;

import java.io.File;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.action.ProjectLifecycleAction;
import org.mule.tooling.core.classloader.ProjectClasspathUtils;
import org.mule.tooling.core.impl.model.BaseMuleProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.runtime.MuleClasspathContainer;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.MuleUserLibraryClasspathContainer;

public class LoadExternalConfigsFromJarsAction
implements ProjectLifecycleAction {
    @Override
    public void execute(IMuleProject muleProject, IProgressMonitor monitor) {
        try {
            if (muleProject instanceof BaseMuleProject) {
                BaseMuleProject baseMuleProject = (BaseMuleProject)muleProject;
                Predicate<IClasspathEntry> containerFilter = this.isValidContainerForExternalConfigurations();
                List<IClasspathEntry> nonMuleRuntimeClasspathEntries = CoreUtils.getNonMuleRuntimeClasspathEntries(baseMuleProject, containerFilter);
                for (IClasspathEntry userFileEntry : nonMuleRuntimeClasspathEntries) {
                    File realFileFrom = CoreUtils.getFileForClasspathEntry(userFileEntry, muleProject.getJavaProject());
                    if (realFileFrom == null) continue;
                    baseMuleProject.onJarAddedToClasspath(realFileFrom, baseMuleProject);
                }
            }
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("Error getting classpath entries for project " + muleProject.getName(), e);
        }
    }

    private Predicate<IClasspathEntry> isValidContainerForExternalConfigurations() {
        return entry -> !MuleClasspathContainer.isMuleRuntime(entry) && !ProjectClasspathUtils.isJavaContainer(entry) && !MuleUserLibraryClasspathContainer.isMuleLibrary(entry);
    }
}

