/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.externalNames;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.generator.IMuleNamespaces;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.MuleConfiguration;

public final class ExternalConfigsManagementUtils {
    private static final String RESOURCE_PROPERTY = "file";

    public static Set<String> getImportedConfigurations(Collection<MuleConfiguration> newConfigurations) {
        HashSet<String> referencedConfigs = new HashSet<String>();
        for (MuleConfiguration muleConfiguration : newConfigurations) {
            List<IMessageFlowEntity> globalEntries = muleConfiguration.getGlobalEntries();
            for (IMessageFlowEntity messageFlowEntity : globalEntries) {
                String value;
                IReadOnlyProperty property;
                GlobalElement globalElement;
                if (!(messageFlowEntity instanceof GlobalElement) || !ExternalConfigsManagementUtils.isImportElement(globalElement = (GlobalElement)messageFlowEntity) || (property = (IReadOnlyProperty)globalElement.getProperties().getProperty(RESOURCE_PROPERTY)) == null || !StringUtils.isNotBlank((String)(value = property.getValue()))) continue;
                referencedConfigs.add(value.replaceAll("\\\\", "/"));
            }
        }
        return referencedConfigs;
    }

    private static boolean isImportElement(GlobalElement globalElement) {
        return IMuleNamespaces.NS_CORE_IMPORT.getURI().equals(globalElement.getType());
    }

    public static List<String> getConfigFileNames(File file) {
        final ArrayList<String> configFileNames = new ArrayList<String>();
        if (file.exists()) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileSystem fs = FileSystems.newFileSystem(file.toPath());){
                    Path zipRootPath = fs.getPath(fs.getSeparator(), new String[0]);
                    Files.walkFileTree(zipRootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            if (attrs.isRegularFile() && ExternalConfigsManagementUtils.isValidMuleConfigFile(file)) {
                                StringBuilder filePathBuilder = new StringBuilder();
                                int i = 0;
                                while (i < file.getNameCount()) {
                                    filePathBuilder.append(file.getName(i));
                                    if (i < file.getNameCount() - 1) {
                                        filePathBuilder.append("/");
                                    }
                                    ++i;
                                }
                                configFileNames.add(filePathBuilder.toString());
                            }
                            return super.visitFile(file, attrs);
                        }
                    });
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                MuleCorePlugin.logError("Error reading from " + file.getAbsolutePath(), e);
            }
        }
        return configFileNames;
    }

    private static boolean isValidMuleConfigFile(Path path) {
        String fileName = path.getFileName().toString();
        return fileName.endsWith(".xml") && !MuleResourceUtils.isLog4jRelatedFile(fileName) && !"pom.xml".equals(fileName);
    }
}

