/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.extensionpoint;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.utils.extensionpoint.DefaultExtensionContext;
import org.mule.tooling.utils.extensionpoint.features.ExtensionPointCollectorFeature;
import org.mule.tooling.utils.extensionpoint.features.IExtensionReadingContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class PluginVersionFiltered
implements ExtensionPointCollectorFeature {
    private final Version topVersion;

    public PluginVersionFiltered() {
        this(MuleCorePlugin.getContext().getBundle().getVersion());
    }

    public PluginVersionFiltered(Version topVersion) {
        this.topVersion = topVersion;
    }

    public <T> List<T> collect(List<T> readObjects, IExtensionReadingContext<T> readingContext, List<DefaultExtensionContext<T>> rootContexts) {
        ArrayList<T> result = new ArrayList<T>(readObjects.size());
        Map<Object, DefaultExtensionContext<?>> contextsPerObject = this.getContextPerObject(rootContexts);
        for (T extension : readObjects) {
            Bundle bundle = this.getBundle(extension, contextsPerObject);
            if (bundle != null) {
                Version version = bundle.getVersion();
                Version extensionBundleVersion = PluginVersionFiltered.versionWithoutQualifier(version);
                if (this.getTopVersion().compareTo(extensionBundleVersion) < 0) continue;
                result.add(extension);
                continue;
            }
            throw new IllegalArgumentException("Extension " + String.valueOf(extension) + " has a null bundle, bundle must be provided");
        }
        return result;
    }

    private Bundle getBundle(Object extension, Map<Object, DefaultExtensionContext<?>> contextsPerObject) {
        DefaultExtensionContext<?> defaultExtensionContext = contextsPerObject.get(extension);
        if (defaultExtensionContext == null) {
            throw new IllegalStateException("feature was provided an extension object that didn't have a corresponding context");
        }
        return defaultExtensionContext.getBundle();
    }

    private <T> Map<Object, DefaultExtensionContext<?>> getContextPerObject(List<DefaultExtensionContext<T>> rootContexts) {
        return rootContexts.stream().collect(Collectors.toMap(ctx -> ctx.getExtensionObject(), Function.identity()));
    }

    private static Version versionWithoutQualifier(Version version) {
        return new Version(version.getMajor(), version.getMinor(), version.getMicro());
    }

    protected Version getTopVersion() {
        return this.topVersion;
    }
}

