/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.event.resource;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.event.resource.ApiProjectPreCloseEvent;
import org.mule.tooling.core.event.resource.FileChangedEvent;
import org.mule.tooling.core.event.resource.MuleProjectCloseEvent;
import org.mule.tooling.core.event.resource.MuleProjectOpenEvent;
import org.mule.tooling.core.event.resource.MuleProjectPreCloseEvent;
import org.mule.tooling.core.event.resource.MuleProjectPreDeleteEvent;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEvent;

public class ResourceEventPump
implements IResourceChangeListener {
    private final EventBus eventBus;

    public ResourceEventPump(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        List<Object> events = Collections.emptyList();
        int eventType = event.getType();
        switch (eventType) {
            case 8: 
            case 32: {
                break;
            }
            case 2: {
                events = this.onPreClose((IProject)event.getResource());
                break;
            }
            case 4: {
                events = this.onPreDelete((IProject)event.getResource());
                break;
            }
            case 1: 
            case 16: {
                events = this.onResourceChange(event, event.getDelta());
            }
        }
        events.forEach(e -> {
            this.preprocess((IEvent<?>)e);
            this.fireEvent((IEvent<?>)e);
        });
    }

    private List<IEvent<?>> onResourceChange(IResourceChangeEvent event, IResourceDelta delta) {
        Objects.requireNonNull(delta, () -> "delta should always be non-null as per event type documentation");
        ArrayList events = new ArrayList();
        try {
            delta.accept(eachDelta -> {
                boolean leafNode = this.isLeafNode(eachDelta);
                if (leafNode) {
                    List<IEvent<?>> eventsFromDelta = this.visitLeafDeltaNode(eachDelta);
                    events.addAll(eventsFromDelta);
                }
                return !leafNode;
            });
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("There was a problem processing resource change events", e);
        }
        return events;
    }

    private boolean isLeafNode(IResourceDelta eachDelta) {
        return eachDelta.getAffectedChildren().length == 0;
    }

    private List<IEvent<?>> visitLeafDeltaNode(IResourceDelta delta) throws CoreException {
        IProject project;
        List<IEvent<?>> events = Collections.emptyList();
        IResource resource = delta.getResource();
        if (!this.isWorkspaceRoot(resource) && MuleRuntime.isInCache(project = resource.getProject())) {
            events = this.getEventsFromDelta(delta, resource, project);
        }
        return events;
    }

    private boolean isWorkspaceRoot(IResource resource) {
        return resource instanceof IWorkspaceRoot;
    }

    private List<IEvent<?>> getEventsFromDelta(IResourceDelta delta, IResource resource, IProject project) throws CoreException {
        ArrayList events = new ArrayList();
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            switch (delta.getKind()) {
                case 8: 
                case 16: {
                    break;
                }
                case 1: {
                    events.add(FileChangedEvent.created(file));
                    if (!".project".equals(file.getName()) || !CoreUtils.hasMuleNature(project)) break;
                    events.add(new MuleProjectOpenEvent(project));
                    break;
                }
                case 2: {
                    events.add(FileChangedEvent.deleted(file));
                    if (!".project".equals(file.getName())) break;
                    events.add(new MuleProjectCloseEvent(project));
                    break;
                }
                case 4: {
                    if (ResourceEventPump.hasFlag(delta, 256)) {
                        events.add(FileChangedEvent.changed(file));
                    }
                    if (!ResourceEventPump.hasFlag(delta, 131072)) break;
                    FileChangedEvent markersChanged = FileChangedEvent.markersChanged(file, Arrays.asList(delta.getMarkerDeltas()));
                    events.add(markersChanged);
                }
            }
        }
        return events;
    }

    private List<IEvent<?>> onPreClose(IProject project) {
        if (ResourceEventPump.isApiProject(project)) {
            return Arrays.asList(new ApiProjectPreCloseEvent(project));
        }
        Object muleProject = MuleRuntime.create(project);
        return muleProject == null ? Collections.emptyList() : Arrays.asList(new MuleProjectPreCloseEvent((IMuleProject)muleProject));
    }

    private List<IEvent<?>> onPreDelete(IProject project) {
        if (ResourceEventPump.isApiProject(project)) {
            return Arrays.asList(new ApiProjectPreCloseEvent(project));
        }
        Object muleProject = MuleRuntime.create(project);
        return muleProject == null ? Collections.emptyList() : Arrays.asList(new MuleProjectPreCloseEvent((IMuleProject)muleProject), new MuleProjectPreDeleteEvent((IMuleProject)muleProject));
    }

    public static boolean isApiProject(IProject project) {
        try {
            return CoreUtils.hasNature(project, "org.mule.tooling.apidesigner.apiprojectnature");
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("Problem while getting project nature, for project: " + project.getFullPath().toOSString(), e);
            return false;
        }
    }

    protected void preprocess(IEvent<?> event) {
        if (event instanceof MuleProjectCloseEvent) {
            MuleProjectCloseEvent muleProjectCloseEvent = (MuleProjectCloseEvent)event;
            MuleRuntime.removeCached(muleProjectCloseEvent.getProject());
        }
    }

    protected void fireEvent(IEvent<?> event) {
        this.eventBus.fireEvent(event);
    }

    private static boolean hasFlag(IResourceDelta delta, int flag) {
        return (delta.getFlags() & flag) != 0;
    }
}

