/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.event.resource;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.resource.FileChangedEventListener;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.utils.eventbus.EventType;
import org.mule.tooling.utils.eventbus.IEvent;

public class FileChangedEvent
implements IEvent<FileChangedEventListener> {
    private final IFile file;
    private final ChangeType changeType;
    private final List<IMarkerDelta> markerDeltas;

    public static FileChangedEvent changed(IFile file) {
        return new FileChangedEvent(file, ChangeType.CHANGED);
    }

    public static FileChangedEvent created(IFile file) {
        return new FileChangedEvent(file, ChangeType.CREATED);
    }

    public static FileChangedEvent deleted(IFile file) {
        return new FileChangedEvent(file, ChangeType.DELETED);
    }

    public static FileChangedEvent markersChanged(IFile file, List<IMarkerDelta> markerDeltas) {
        return new FileChangedEvent(file, ChangeType.MARKERS, markerDeltas);
    }

    private FileChangedEvent(IFile file, ChangeType changeType) {
        this(file, changeType, Collections.emptyList());
    }

    public FileChangedEvent(IFile file, ChangeType changeType, List<IMarkerDelta> markerDeltas) {
        this.file = file;
        this.changeType = changeType;
        this.markerDeltas = markerDeltas;
    }

    public boolean markerTypeChanged(String markerType) {
        return this.markerDeltas.stream().anyMatch(marker -> marker.isSubtypeOf(markerType));
    }

    public boolean isEventType(ChangeType type) {
        return this.changeType.equals((Object)type);
    }

    public boolean isInOutputLocation() {
        return this.getMuleProject().map(project -> CoreUtils.isInTargetLocation(project, (IResource)this.getFile())).orElse(false);
    }

    public IFile getFile() {
        return this.file;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public List<IMarkerDelta> getAddedMarkers() {
        return this.getDeltasOfKind(1);
    }

    public List<IMarkerDelta> getChangedMarkers() {
        return this.getDeltasOfKind(4);
    }

    public List<IMarkerDelta> getRemovedMarkers() {
        return this.getDeltasOfKind(2);
    }

    private List<IMarkerDelta> getDeltasOfKind(int kind) {
        return this.markerDeltas.stream().filter(delta -> delta.getKind() == kind).collect(Collectors.toList());
    }

    public Optional<IMuleProject> getMuleProject() {
        IProject project = this.file.getProject();
        Optional<IMuleProject> muleProject = project != null && project.exists() && project.isAccessible() ? Optional.ofNullable(MuleRuntime.create(project)) : Optional.empty();
        return muleProject;
    }

    public EventType<FileChangedEventListener> getAssociatedType() {
        return CoreEventTypes.ResourceEvents.ON_FILE_RESOURCE_CHANGED;
    }

    public void dispatch(FileChangedEventListener handler) {
        handler.onFileChanged(this);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.changeType == null ? 0 : this.changeType.hashCode());
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + (this.markerDeltas == null ? 0 : this.markerDeltas.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileChangedEvent other = (FileChangedEvent)obj;
        if (this.changeType != other.changeType) {
            return false;
        }
        if (this.file == null ? other.file != null : !this.file.equals((Object)other.file)) {
            return false;
        }
        return !(this.markerDeltas == null ? other.markerDeltas != null : !this.markerDeltas.equals(other.markerDeltas));
    }

    public String toString() {
        return "FileChangedEvent [changeType=" + String.valueOf((Object)this.changeType) + ", file=" + String.valueOf(this.file) + "]";
    }

    public static enum ChangeType {
        CREATED,
        DELETED,
        CHANGED,
        MARKERS;

    }
}

