/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.event;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.PomChangedEventHandler;
import org.mule.tooling.utils.eventbus.EventType;
import org.mule.tooling.utils.eventbus.IEvent;

public class PomChangedEvent
implements IEvent<PomChangedEventHandler> {
    public static final int FILE_CHANGED = 0;
    public static final int POST_CHANGE = 1;
    private IResource resource;
    private IProject project;
    private int kind;

    private PomChangedEvent(IResource resource, IProject project, int kind) {
        this.resource = resource;
        this.project = project;
        this.kind = kind;
    }

    private PomChangedEvent(IResource resource, int kind) {
        this.resource = resource;
        this.kind = kind;
    }

    public static PomChangedEvent fileChanged(IResource resource, IProject project) {
        return new PomChangedEvent(resource, project, 0);
    }

    public static PomChangedEvent postFileChanged(IResource resource, IProject muleProject) {
        return new PomChangedEvent(resource, muleProject, 1);
    }

    public EventType<PomChangedEventHandler> getAssociatedType() {
        return CoreEventTypes.POM_CHANGED;
    }

    public void dispatch(PomChangedEventHandler handler) {
        switch (this.kind) {
            case 0: {
                handler.onPomChanged(this.resource, this.project);
                break;
            }
            case 1: {
                handler.postPomChanged(this.resource, this.project);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown event kind " + this.kind);
            }
        }
    }
}

