/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.event;

import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IMuleRuntimeChangedListener;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.utils.eventbus.EventType;
import org.mule.tooling.utils.eventbus.IEvent;

public class MuleRuntimeChangedEvent
implements IEvent<IMuleRuntimeChangedListener> {
    private String fromId;
    private String toId;
    private boolean before;
    private IMuleProject muleProject;

    MuleRuntimeChangedEvent(String fromId, String toId, IMuleProject muleProject, boolean before) {
        this.fromId = fromId;
        this.toId = toId;
        this.muleProject = muleProject;
        this.before = before;
    }

    public EventType<IMuleRuntimeChangedListener> getAssociatedType() {
        return CoreEventTypes.ON_MULE_RUNTIME_CHANGED;
    }

    public void dispatch(IMuleRuntimeChangedListener handler) {
        if (this.before) {
            handler.beforeChanging(this.fromId, this.toId, this.muleProject);
        } else {
            handler.afterChanging(this.fromId, this.toId, this.muleProject);
        }
    }

    public static MuleRuntimeChangedEvent createBeforeRuntimeChangeEvent(String fromId, String toId, IMuleProject muleProject) {
        return new MuleRuntimeChangedEvent(fromId, toId, muleProject, true);
    }

    public static MuleRuntimeChangedEvent createAfterRuntimeChangeEvent(String fromId, String toId, IMuleProject muleProject) {
        return new MuleRuntimeChangedEvent(fromId, toId, muleProject, false);
    }
}

