/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.event;

import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IMuleConfigSaveListener;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.utils.eventbus.EventType;
import org.mule.tooling.utils.eventbus.IEvent;

public class MuleConfigurationSavedEvent
implements IEvent<IMuleConfigSaveListener> {
    private final IMuleProject muleProject;
    private final MuleConfiguration muleConfiguration;

    public MuleConfigurationSavedEvent(IMuleProject muleProject, MuleConfiguration muleConfiguration) {
        this.muleProject = muleProject;
        this.muleConfiguration = muleConfiguration;
    }

    public String toString() {
        return "MuleConfiguationSavedEvent [config=" + this.muleConfiguration.getName() + ", muleProject=" + this.muleProject.getName() + "]";
    }

    public EventType<IMuleConfigSaveListener> getAssociatedType() {
        return CoreEventTypes.ON_CONFIG_SAVE;
    }

    public void dispatch(IMuleConfigSaveListener handler) {
        handler.muleConfigurationSaved(this.muleProject, this.muleConfiguration);
    }

    public MuleConfiguration getMuleConfiguration() {
        return this.muleConfiguration;
    }

    public IMuleProject getMuleProject() {
        return this.muleProject;
    }
}

