/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.event;

import java.io.File;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IClasspathEventListener;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.utils.eventbus.EventType;
import org.mule.tooling.utils.eventbus.IEvent;

public class JarRemovedEvent
implements IEvent<IClasspathEventListener> {
    private final IMuleProject muleProject;
    private File file;

    public JarRemovedEvent(File file, IMuleProject muleProject) {
        this.file = file;
        this.muleProject = muleProject;
    }

    public EventType<IClasspathEventListener> getAssociatedType() {
        return CoreEventTypes.ON_JAR_REMOVED;
    }

    public void dispatch(IClasspathEventListener handler) {
        handler.onJarRemovedFromClasspath(this.file, this.muleProject);
    }

    public File getFile() {
        return this.file;
    }

    public IMuleProject getMuleProject() {
        return this.muleProject;
    }

    public String toString() {
        return "JarRemovedEvent [removedJar=" + this.file.toString() + ", muleProject=" + String.valueOf(this.muleProject) + "]";
    }
}

