/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.event;

import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IClasspathEventListener;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.model.project.MuleExtension;
import org.mule.tooling.utils.eventbus.EventType;
import org.mule.tooling.utils.eventbus.IEvent;

public class ExtensionRemovedEvent
implements IEvent<IClasspathEventListener> {
    private final MuleExtension removedExtension;
    private final IMuleProject muleProject;

    public ExtensionRemovedEvent(MuleExtension removedExtension, IMuleProject muleProject) {
        this.removedExtension = removedExtension;
        this.muleProject = muleProject;
    }

    public EventType<IClasspathEventListener> getAssociatedType() {
        return CoreEventTypes.ON_EXTENSION_REMOVED;
    }

    public void dispatch(IClasspathEventListener handler) {
        handler.onExtensionRemovedFromClasspath(this.removedExtension, this.muleProject);
    }

    public MuleExtension getRemovedExtension() {
        return this.removedExtension;
    }

    public IMuleProject getMuleProject() {
        return this.muleProject;
    }

    public String toString() {
        return "ExtensionRemovedEvent [removedExtension=" + String.valueOf(this.removedExtension) + ", muleProject=" + String.valueOf(this.muleProject) + "]";
    }
}

