/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.event;

import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.DomainChangedEventHandler;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.IMuleDomain;
import org.mule.tooling.utils.eventbus.EventType;
import org.mule.tooling.utils.eventbus.IEvent;

public class DomainChangedEvent<T>
implements IEvent<DomainChangedEventHandler> {
    private final ChangeState kind;
    private final IMuleApplicationProject applicationProject;
    private final T parameter;

    public static DomainChangedEvent<IMuleDomain> changedSuccessfully(IMuleApplicationProject muleProject, IMuleDomain domain) {
        return new DomainChangedEvent<IMuleDomain>(ChangeState.SUCCESS, muleProject, domain);
    }

    public static DomainChangedEvent<MavenDependency> changedFailed(IMuleApplicationProject muleProject, MavenDependency dependency2) {
        return new DomainChangedEvent<MavenDependency>(ChangeState.FAIL, muleProject, dependency2);
    }

    private DomainChangedEvent(ChangeState kind, IMuleApplicationProject applicationProject, T parameter) {
        this.kind = kind;
        this.applicationProject = applicationProject;
        this.parameter = parameter;
    }

    public EventType<DomainChangedEventHandler> getAssociatedType() {
        return CoreEventTypes.DOMAIN_CHANGED;
    }

    public void dispatch(DomainChangedEventHandler handler) {
        switch (this.kind) {
            case SUCCESS: {
                handler.onDomainChangedSuccessfully(this.applicationProject, (IMuleDomain)this.parameter);
                break;
            }
            case FAIL: {
                handler.onDomainChangedFailed(this.applicationProject, (MavenDependency)this.parameter);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown event kind " + String.valueOf((Object)this.kind));
            }
        }
    }

    private static enum ChangeState {
        SUCCESS,
        FAIL;

    }
}

