/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.event;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.StudioDesignContextRunner;
import org.mule.tooling.core.event.ApiSpecRemovedEvent;
import org.mule.tooling.core.event.ExtensionRemovedEvent;
import org.mule.tooling.core.event.JarAddedEvent;
import org.mule.tooling.core.event.JarRemovedEvent;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.m2.MavenConfiguration;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.runtime.ApiSpecClasspathContainer;
import org.mule.tooling.core.runtime.ClasspathContainerConfigurer;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.MuleUserLibraryClasspathContainer;
import org.mule.tooling.core.utils.StudioContextLazyValue;
import org.mule.tooling.model.project.MuleExtension;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class ClasspathEventsListener
implements IElementChangedListener {
    private StudioContextLazyValue<EventBus> eventBus = new StudioContextLazyValue<EventBus>(EventBus.class);
    private StudioContextLazyValue<ClasspathContainerConfigurer> classpathConfigurer = new StudioContextLazyValue<ClasspathContainerConfigurer>(ClasspathContainerConfigurer.class);

    private EventBus getEventBus() {
        return this.eventBus.getOrCompute();
    }

    private ClasspathContainerConfigurer getClasspathConfigurer() {
        return this.classpathConfigurer.getOrCompute();
    }

    public void elementChanged(ElementChangedEvent event) {
        IJavaElementDelta delta = event.getDelta();
        try {
            this.processDelta(delta, false);
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("There was an error while processing a Java event: \n" + delta.toString(), e);
        }
    }

    private void processDelta(IJavaElementDelta delta, boolean classpathChanged) throws CoreException {
        if (classpathChanged || this.hasFlag(delta, 131264)) {
            this.processClasspathChangedDelta(delta);
        } else if (this.hasFlag(delta, 8)) {
            this.processChildren(delta, classpathChanged || this.hasFlag(delta, 0x200000));
        }
    }

    protected List<String> getFlags(IJavaElementDelta delta) throws CoreException {
        LinkedList<String> flags = new LinkedList<String>();
        if (this.hasFlag(delta, 131072)) {
            flags.add("F_CLASSPATH_CHANGED");
        } else if (this.hasFlag(delta, 8)) {
            flags.add("F_CHILDREN");
        } else if (this.hasFlag(delta, 64)) {
            flags.add("F_ADDED_TO_CLASSPATH");
        } else if (this.hasFlag(delta, 0x400000)) {
            flags.add("F_ANNOTATIONS");
        } else if (this.hasFlag(delta, 32768)) {
            flags.add("F_ARCHIVE_CONTENT_CHANGED");
        } else if (this.hasFlag(delta, 524288)) {
            flags.add("F_AST_AFFECTED");
        } else if (this.hasFlag(delta, 0x100000)) {
            flags.add("F_CATEGORIES");
        } else if (this.hasFlag(delta, 256)) {
            flags.add("F_CLASSPATH_REORDER");
        } else if (this.hasFlag(delta, 1024)) {
            flags.add("F_CLOSED");
        } else if (this.hasFlag(delta, 1)) {
            flags.add("F_CONTENT");
        } else if (this.hasFlag(delta, 16384)) {
            flags.add("F_FINE_GRAINED");
        } else if (this.hasFlag(delta, 2)) {
            flags.add("F_MODIFIERS");
        } else if (this.hasFlag(delta, 16)) {
            flags.add("F_MOVED_FROM");
        } else if (this.hasFlag(delta, 32)) {
            flags.add("F_MOVED_TO");
        } else if (this.hasFlag(delta, 512)) {
            flags.add("F_OPENED");
        } else if (this.hasFlag(delta, 262144)) {
            flags.add("F_PRIMARY_RESOURCE");
        } else if (this.hasFlag(delta, 65536)) {
            flags.add("F_PRIMARY_WORKING_COPY");
        } else if (this.hasFlag(delta, 128)) {
            flags.add("F_REMOVED_FROM_CLASSPATH");
        } else if (this.hasFlag(delta, 256)) {
            flags.add("F_REORDER");
        } else if (this.hasFlag(delta, 0x200000)) {
            flags.add("F_RESOLVED_CLASSPATH_CHANGED");
        } else if (this.hasFlag(delta, 4096)) {
            flags.add("F_SOURCEATTACHED");
        } else if (this.hasFlag(delta, 8192)) {
            flags.add("F_SOURCEDETACHED");
        } else if (this.hasFlag(delta, 2048)) {
            flags.add("F_SUPER_TYPES");
        }
        return flags;
    }

    private void processClasspathChangedDelta(final IJavaElementDelta delta) throws CoreException {
        IMuleProject muleProject;
        IJavaElement changedElement = delta.getElement();
        if (changedElement.getJavaProject() instanceof IJavaProject && (muleProject = this.getMuleProject((IJavaElement)changedElement.getJavaProject())) != null) {
            StudioDesignContextRunner.runSilentWithMuleProject(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ClasspathEventsListener.this.onMuleClasspathChanged(muleProject, delta);
                    return null;
                }
            }, muleProject);
        }
    }

    private IMuleProject getMuleProject(IJavaElement changedElement) throws CoreException {
        IJavaProject javaProject = (IJavaProject)changedElement;
        Object muleProject = MuleRuntime.create(javaProject.getProject());
        return muleProject;
    }

    private void onMuleClasspathChanged(IMuleProject muleProject, IJavaElementDelta projectDelta) {
        IJavaElementDelta[] affectedChildren = projectDelta.getAffectedChildren();
        ArrayList<IJavaElementDelta> removedChildren = new ArrayList<IJavaElementDelta>();
        ArrayList<IJavaElementDelta> addedChildren = new ArrayList<IJavaElementDelta>();
        this.classifyDeltas(projectDelta, affectedChildren, removedChildren, addedChildren);
        this.onMuleClasspathChangedEvent(muleProject, removedChildren, ChangeType.REMOVED);
        this.onMuleClasspathChangedEvent(muleProject, addedChildren, ChangeType.ADDED);
    }

    private void classifyDeltas(IJavaElementDelta rootDelta, IJavaElementDelta[] deltas, List<IJavaElementDelta> removedChildren, List<IJavaElementDelta> addedChildren) {
        this.classifyDelta(rootDelta, addedChildren, removedChildren);
        int i = 0;
        while (i < deltas.length) {
            IJavaElementDelta delta = deltas[i];
            this.classifyDelta(delta, addedChildren, removedChildren);
            ++i;
        }
    }

    private void classifyDelta(IJavaElementDelta delta, List<IJavaElementDelta> addedChildren, List<IJavaElementDelta> removedChildren) {
        if (delta.getKind() == 1 || this.hasFlag(delta, 64)) {
            addedChildren.add(delta);
        } else if (this.hasFlag(delta, 128)) {
            removedChildren.add(delta);
        }
    }

    private void onMuleClasspathChangedEvent(IMuleProject muleProject, List<IJavaElementDelta> affectedChildren, ChangeType changeType) {
        for (IJavaElementDelta delta : affectedChildren) {
            IJavaElement element = delta.getElement();
            IPackageFragmentRoot affectedJar = (IPackageFragmentRoot)element.getAdapter(IPackageFragmentRoot.class);
            if (affectedJar == null || !affectedJar.getElementName().endsWith(".jar") && !affectedJar.getElementName().endsWith(".zip")) continue;
            this.processJarEvent(muleProject, affectedJar, changeType);
        }
    }

    private void processJarEvent(IMuleProject muleProject, IPackageFragmentRoot affectedJar, ChangeType changeType) {
        MuleExtension muleExtension = this.getCorrespondingMuleExtension(muleProject, affectedJar);
        if (muleExtension != null) {
            if (ChangeType.REMOVED.equals((Object)changeType) && !this.isInitializing(muleExtension, muleProject)) {
                this.fireEvent(new ExtensionRemovedEvent(muleExtension, muleProject));
            } else if (ChangeType.ADDED.equals((Object)changeType)) {
                this.getClasspathConfigurer().containerInitialized(MuleUserLibraryClasspathContainer.getContainerPath(muleExtension.getQualifier()), muleProject.getJavaProject());
            }
        } else {
            Optional<MavenDependency> apiSpecDependency = this.getCorrespondingApiSpec(muleProject, affectedJar);
            if (apiSpecDependency.isPresent()) {
                if (ChangeType.REMOVED.equals((Object)changeType) && !this.isInitializing(apiSpecDependency.get(), muleProject)) {
                    this.fireEvent(new ApiSpecRemovedEvent(apiSpecDependency.get(), muleProject));
                } else if (ChangeType.ADDED.equals((Object)changeType)) {
                    this.getClasspathConfigurer().containerInitialized(ApiSpecClasspathContainer.getContainerPath(apiSpecDependency.get()), muleProject.getJavaProject());
                }
            } else if (ChangeType.ADDED.equals((Object)changeType)) {
                if (affectedJar.isExternal() || affectedJar.exists() && this.isUserLibrary(affectedJar, muleProject)) {
                    MavenDependency dependencyFromPath;
                    IPath jarPath;
                    Path m2repoPath = new Path(MavenConfiguration.instance().getLocalRepositoryPath());
                    if (m2repoPath.isPrefixOf(jarPath = affectedJar.getPath()) && MavenUtils.isMulePlugin(dependencyFromPath = MavenUtils.getDependencyFromPath(jarPath.toFile()))) {
                        IPath containerPath = MuleUserLibraryClasspathContainer.getContainerPath(MavenUtils.getGAV(dependencyFromPath));
                        this.getClasspathConfigurer().containerInitialized(containerPath, muleProject.getJavaProject());
                    }
                    this.fireEvent(new JarAddedEvent(ClasspathEventsListener.getRealFileFromFragment(affectedJar), muleProject));
                }
            } else if (ChangeType.REMOVED.equals((Object)changeType) && this.isUserLibraryFile(affectedJar, muleProject)) {
                this.fireEvent(new JarRemovedEvent(ClasspathEventsListener.getRealFileFromFragment(affectedJar), muleProject));
            }
        }
    }

    private Optional<MavenDependency> getCorrespondingApiSpec(IMuleProject muleProject, IPackageFragmentRoot affectedJar) {
        Optional<MavenDependency> mavenDep = Optional.empty();
        MavenDependency dependencyFromPath = MavenUtils.getDependencyFromPath(affectedJar.getPath().toFile());
        if (MavenUtils.isApiSpec(dependencyFromPath) || MavenUtils.isAsyncApiSpec(dependencyFromPath)) {
            mavenDep = Optional.of(dependencyFromPath);
        }
        return mavenDep;
    }

    private boolean isInitializing(MuleExtension muleExtension, IMuleProject muleProject) {
        return this.isInitializing(MuleUserLibraryClasspathContainer.getContainerPath(muleExtension.getQualifier()), muleProject);
    }

    private boolean isInitializing(MavenDependency mavenDep, IMuleProject muleProject) {
        return this.getClasspathConfigurer().isContainerInitializing(ApiSpecClasspathContainer.getContainerPath(mavenDep), muleProject.getJavaProject());
    }

    private boolean isInitializing(IPath classpathPath, IMuleProject muleProject) {
        return this.getClasspathConfigurer().isContainerInitializing(classpathPath, muleProject.getJavaProject());
    }

    private boolean isUserLibraryFile(IPackageFragmentRoot affectedJar, IMuleProject muleProject) {
        IMuleApplicationProject muleApplicationProject;
        boolean isUserLibraryFile = false;
        if (MuleProjectKind.APPLICATION.equals(muleProject.getKind()) && !(muleApplicationProject = MuleProjectKind.APPLICATION.adapt(muleProject)).isTestResource(affectedJar.getResource())) {
            isUserLibraryFile = affectedJar.isArchive() && !this.isInMuleRuntime(affectedJar) && !CoreUtils.isMuleExternalContributionDependencyLib(affectedJar.getPath());
        }
        return isUserLibraryFile;
    }

    private boolean isUserLibrary(IPackageFragmentRoot affectedJar, IMuleProject muleProject) {
        boolean isUserLibrary;
        block3: {
            isUserLibrary = false;
            try {
                IMuleApplicationProject muleApplicationProject;
                if (!MuleProjectKind.APPLICATION.equals(muleProject.getKind()) || (muleApplicationProject = MuleProjectKind.APPLICATION.adapt(muleProject)).isTestResource(affectedJar.getResource())) break block3;
                IPath path = affectedJar.getPath();
                List<IClasspathEntry> nonMuleRuntimeClasspathEntries = CoreUtils.getNonMuleRuntimeClasspathEntries(muleProject);
                for (IClasspathEntry iClasspathEntry : nonMuleRuntimeClasspathEntries) {
                    if (!JavaCore.getResolvedClasspathEntry((IClasspathEntry)iClasspathEntry).getPath().equals((Object)path)) continue;
                    isUserLibrary = true;
                    break;
                }
            }
            catch (CoreException e) {
                MuleCorePlugin.logError("Error while checking user libraries...", e);
            }
        }
        return isUserLibrary;
    }

    private MuleExtension getCorrespondingMuleExtension(IMuleProject muleProject, IPackageFragmentRoot addedJar) {
        String jarName = addedJar.getPath().lastSegment();
        List<ExternalContributionMuleModule> projectExternalModules = muleProject.getModuleManager(EditingScope.TEST).getExternalModules();
        return projectExternalModules.stream().filter(module -> jarName.equals(module.getContributionJar())).findFirst().flatMap(module -> muleProject.getDeclaredExtensions().stream().filter(ext -> ext.getQualifier().equals(module.getId())).findFirst()).orElse(null);
    }

    private void fireEvent(IEvent<? extends IEventHandler> event) {
        this.getEventBus().fireEvent(event);
    }

    private void processChildren(IJavaElementDelta delta, boolean classpathChanged) throws CoreException {
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta childDelta = iJavaElementDeltaArray[n2];
            this.processDelta(childDelta, classpathChanged);
            ++n2;
        }
    }

    private boolean hasFlag(IJavaElementDelta delta, int flag) {
        return (delta.getFlags() & flag) != 0;
    }

    private boolean isInMuleRuntime(IPackageFragmentRoot jar) {
        Optional<IServerDefinition> containingServer = MuleCorePlugin.getServerManager().getContainingServer(jar.getPath().toOSString());
        return containingServer.isPresent();
    }

    private static File getRealFileFromFragment(IPackageFragmentRoot jar) {
        File realFile = null;
        if (jar != null) {
            realFile = !jar.isExternal() ? jar.getResource().getRawLocation().toFile() : jar.getPath().toFile();
        }
        return realFile;
    }

    private static enum ChangeType {
        ADDED,
        REMOVED;

    }
}

