/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.event;

import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IClasspathEventListener;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.utils.eventbus.EventType;
import org.mule.tooling.utils.eventbus.IEvent;

public class ApiSpecRemovedEvent
implements IEvent<IClasspathEventListener> {
    private final IMuleProject muleProject;
    private MavenDependency apiSpecDependency;

    public ApiSpecRemovedEvent(MavenDependency apiSpecDependency, IMuleProject muleProject) {
        this.apiSpecDependency = apiSpecDependency;
        this.muleProject = muleProject;
    }

    public EventType<IClasspathEventListener> getAssociatedType() {
        return CoreEventTypes.ON_API_SPEC_REMOVED;
    }

    public void dispatch(IClasspathEventListener handler) {
        handler.onApiRemovedFromClasspath(this.apiSpecDependency, this.muleProject);
    }

    public IMuleProject getMuleProject() {
        return this.muleProject;
    }

    public String toString() {
        return "ApiSpecRemovedEvent [removedDependency=" + this.apiSpecDependency.toString() + ", muleProject=" + String.valueOf(this.muleProject) + "]";
    }
}

