/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.errorHandling;

import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.WorkbenchErrorHandler;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IErrorLoggedListener;
import org.mule.tooling.utils.LoggingStatus;
import org.mule.tooling.utils.eventbus.EventType;
import org.mule.tooling.utils.eventbus.IEvent;

public class MuleStudioErrorHandler
extends WorkbenchErrorHandler {
    public void handle(StatusAdapter statusAdapter, int style) {
        if (statusAdapter.getStatus().getException() != null) {
            boolean isLogging = statusAdapter.getStatus() instanceof LoggingStatus;
            if (statusAdapter.getStatus().getSeverity() == 4 && !isLogging) {
                this.fireEvent(statusAdapter);
            }
        }
        super.handle(statusAdapter, style);
    }

    private void fireEvent(final StatusAdapter statusAdapter) {
        MuleCorePlugin.getEventBus().fireEvent((IEvent)new IEvent<IErrorLoggedListener>(){

            public EventType<IErrorLoggedListener> getAssociatedType() {
                return CoreEventTypes.ON_ERROR_LOGGED;
            }

            public void dispatch(IErrorLoggedListener handler) {
                handler.onErrorLogged(statusAdapter);
            }
        });
    }
}

