/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.dom.w3c.impl.state;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.dom.INodeListWrapper;
import org.mule.tooling.core.dom.w3c.impl.AbstractNodeWrapperW3C;
import org.mule.tooling.core.dom.w3c.impl.ElementWrapperW3C;
import org.mule.tooling.core.dom.w3c.impl.NodeListW3C;
import org.mule.tooling.core.dom.w3c.impl.W3CFactory;
import org.mule.tooling.core.dom.w3c.impl.actions.IAddAttributeAction;
import org.mule.tooling.core.dom.w3c.impl.actions.IAddChildAction;
import org.mule.tooling.core.dom.w3c.impl.actions.IDeleteAction;
import org.mule.tooling.core.dom.w3c.impl.actions.impl.AppendChild;
import org.mule.tooling.core.dom.w3c.impl.actions.impl.InsertAfter;
import org.mule.tooling.core.dom.w3c.impl.actions.impl.InsertAt;
import org.mule.tooling.core.dom.w3c.impl.actions.impl.InsertBefore;
import org.mule.tooling.core.dom.w3c.impl.state.IElementState;
import org.w3c.dom.Element;

public class VirtualNodeStateW3C
implements IElementState {
    private ElementWrapperW3C parent;
    private ElementWrapperW3C element;
    private TreeMap<Integer, IElementWrapper> handledElements;

    public VirtualNodeStateW3C(ElementWrapperW3C parent, ElementWrapperW3C element, List<IElementWrapper> childElements) {
        this.parent = parent;
        this.element = element;
        this.handledElements = this.toPositionMap(childElements);
    }

    private TreeMap<Integer, IElementWrapper> toPositionMap(List<IElementWrapper> childElements) {
        TreeMap<Integer, IElementWrapper> positionToElementMap = new TreeMap<Integer, IElementWrapper>();
        INodeListWrapper<IElementWrapper> parentChildren = this.parent.getChildElements();
        for (IElementWrapper child : childElements) {
            positionToElementMap.put(parentChildren.indexOf(child), child);
        }
        return positionToElementMap;
    }

    @Override
    public IElementState transition(ElementWrapperW3C parent, ElementWrapperW3C element) {
        throw new IllegalStateException("Placeholder state cannot be transitioned");
    }

    @Override
    public void handleAttributeRequest(ElementWrapperW3C elementWrapperW3C, IAddAttributeAction addAttributeAction) {
        throw new UnsupportedOperationException("cannot add attributes to placeholder elements");
    }

    @Override
    public void handleAddRequest(ElementWrapperW3C element, AbstractNodeWrapperW3C child, IAddChildAction addAction) {
        this.parent.getState().handleAddRequest(this.parent, child, this.adapt(addAction));
        ArrayList<IElementWrapper> newElements = new ArrayList<IElementWrapper>(this.handledElements.values());
        newElements.add((IElementWrapper)((Object)child));
        this.handledElements = this.toPositionMap(newElements);
    }

    private IAddChildAction adapt(IAddChildAction addAction) {
        IAddChildAction newAction = addAction;
        if (addAction instanceof AppendChild) {
            if (!this.handledElements.isEmpty()) {
                AbstractNodeWrapperW3C lastElement = (AbstractNodeWrapperW3C)((Object)this.handledElements.lastEntry().getValue());
                newAction = new InsertAfter(this.parent, addAction.getChild(), lastElement, this.parent.getSchemaLocationLookup());
            } else {
                IElementWrapper nextElement = this.element.getConfiguration().getNextLinkedElement();
                if (nextElement != null && nextElement instanceof AbstractNodeWrapperW3C) {
                    newAction = new InsertBefore(this.parent, addAction.getChild(), (AbstractNodeWrapperW3C)((Object)nextElement), this.parent.getSchemaLocationLookup());
                }
            }
        } else if (addAction instanceof InsertAt) {
            int baseIndex = 0;
            ElementWrapperW3C previousElement = (ElementWrapperW3C)this.element.getConfiguration().getPreviousElement();
            while (previousElement != null) {
                baseIndex += previousElement.getChildElements().size();
                previousElement = (ElementWrapperW3C)previousElement.getConfiguration().getPreviousElement();
            }
            if (baseIndex > 0) {
                InsertAt insertAt = (InsertAt)addAction;
                newAction = new InsertAt(this.parent, baseIndex + insertAt.getIndex(), insertAt.getChild(), this.parent.getSchemaLocationLookup());
            }
        }
        return newAction;
    }

    @Override
    public void handleDeleteRequest(ElementWrapperW3C element, AbstractNodeWrapperW3C child, IDeleteAction deleteAction) {
        this.parent.getState().handleDeleteRequest(this.parent, child, deleteAction);
        this.removeFromHandledElements(child);
    }

    private void removeFromHandledElements(AbstractNodeWrapperW3C child) {
        Set<Map.Entry<Integer, IElementWrapper>> entrySet = this.handledElements.entrySet();
        Iterator<Map.Entry<Integer, IElementWrapper>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, IElementWrapper> entry = iterator.next();
            if (entry.getValue() != child) continue;
            iterator.remove();
            break;
        }
    }

    @Override
    public int getChildElementsSize(ElementWrapperW3C element) {
        return this.handledElements.size();
    }

    @Override
    public INodeListWrapper<IElementWrapper> getChildElements(ElementWrapperW3C elementWrapperW3C) {
        ArrayList<Element> w3cElements = new ArrayList<Element>(this.handledElements.size());
        for (IElementWrapper handledElement : this.handledElements.values()) {
            if (!(handledElement instanceof ElementWrapperW3C)) continue;
            w3cElements.add(((ElementWrapperW3C)handledElement).getNode());
        }
        return W3CFactory.wrapChildElements(new NodeListW3C(w3cElements), elementWrapperW3C.getSchemaLocationLookup());
    }

    @Override
    public boolean isLinked() {
        return false;
    }

    @Override
    public IElementWrapper getLinkedElement(ElementWrapperW3C elementWrapperW3C) {
        for (IElementWrapper wrapper : this.handledElements.values()) {
            ElementWrapperW3C w3cElement;
            IElementWrapper foundLinkedElement;
            if (!(wrapper instanceof ElementWrapperW3C) || (foundLinkedElement = (w3cElement = (ElementWrapperW3C)wrapper).getState().getLinkedElement(w3cElement)) == null) continue;
            return foundLinkedElement;
        }
        return null;
    }
}

