/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.dom.w3c.impl.state;

import java.util.ArrayList;
import java.util.List;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.dom.INodeListWrapper;
import org.mule.tooling.core.dom.INodeWrapper;
import org.mule.tooling.core.dom.w3c.impl.AbstractNodeWrapperW3C;
import org.mule.tooling.core.dom.w3c.impl.ElementWrapperW3C;
import org.mule.tooling.core.dom.w3c.impl.NodeListW3C;
import org.mule.tooling.core.dom.w3c.impl.W3CFactory;
import org.mule.tooling.core.dom.w3c.impl.actions.IAddAttributeAction;
import org.mule.tooling.core.dom.w3c.impl.actions.IAddChildAction;
import org.mule.tooling.core.dom.w3c.impl.actions.IDeleteAction;
import org.mule.tooling.core.dom.w3c.impl.state.AbstractStateW3C;
import org.mule.tooling.core.dom.w3c.impl.state.IElementState;
import org.mule.tooling.core.dom.w3c.impl.state.LinkedStateW3C;
import org.mule.tooling.core.dom.w3c.impl.state.PendingLinkageStateW3C;
import org.w3c.dom.Element;

public class UnlinkedStateW3C
extends AbstractStateW3C
implements IElementState {
    private List<IAddChildAction> deferredActions = new ArrayList<IAddChildAction>();
    private List<IAddAttributeAction> deferredAttributeActions = new ArrayList<IAddAttributeAction>();

    @Override
    public int getChildElementsSize(ElementWrapperW3C element) {
        return this.deferredActions.size() + this.getNodeChildElementsSize(element);
    }

    private int getNodeChildElementsSize(ElementWrapperW3C element) {
        return W3CFactory.wrapChildElements(element.getNode().getChildNodes(), element.getSchemaLocationLookup()).size();
    }

    @Override
    public INodeListWrapper<IElementWrapper> getChildElements(ElementWrapperW3C elementWrapperW3C) {
        ArrayList<Element> w3cElements = new ArrayList<Element>(this.deferredActions.size());
        for (IAddChildAction addChildAction : this.deferredActions) {
            AbstractNodeWrapperW3C child = addChildAction.getChild();
            if (!(child instanceof ElementWrapperW3C)) continue;
            w3cElements.add(((ElementWrapperW3C)child).getNode());
        }
        return W3CFactory.wrapChildElements(new NodeListW3C(w3cElements), elementWrapperW3C.getSchemaLocationLookup());
    }

    @Override
    public void handleAttributeRequest(ElementWrapperW3C elementWrapperW3C, IAddAttributeAction addAttributeAction) {
        boolean added = addAttributeAction.addAttribute();
        if (added) {
            this.deferredAttributeActions.add(addAttributeAction);
        }
    }

    @Override
    public void handleAddRequest(ElementWrapperW3C element, AbstractNodeWrapperW3C child, IAddChildAction addAction) {
        this.deferredActions.add(addAction);
    }

    @Override
    public IElementState transition(ElementWrapperW3C parent, ElementWrapperW3C element) {
        if (parent == null) {
            throw new IllegalStateException("Cannot unlink UnlinkedState");
        }
        int minimumChildren = element.getConfiguration().getMinimumChildElementsToShow();
        int childElementsSize = this.getNodeChildElementsSize(element);
        boolean showThisElement = this.getChildElementsSize(element) >= minimumChildren;
        ElementWrapperW3C parentForActions = showThisElement ? element : parent;
        int addedChildren = 0;
        for (IAddChildAction iAddChildAction : this.deferredActions) {
            IAddChildAction iAddChildAction2 = this.getOrderedAction(element, iAddChildAction.getChild(), iAddChildAction, false);
            addedChildren += iAddChildAction2.apply(parentForActions) ? 1 : 0;
            this.link(iAddChildAction2.getChild(), parentForActions);
        }
        if (childElementsSize + addedChildren >= minimumChildren) {
            for (IAddAttributeAction iAddAttributeAction : this.deferredAttributeActions) {
                iAddAttributeAction.addNamespace();
            }
            return new LinkedStateW3C(parent.getNode());
        }
        ArrayList<INodeWrapper> arrayList = new ArrayList<INodeWrapper>();
        for (IAddChildAction action : this.deferredActions) {
            arrayList.add(action.getChild());
        }
        return new PendingLinkageStateW3C(parent, element, this.deferredAttributeActions, arrayList);
    }

    @Override
    public void handleDeleteRequest(ElementWrapperW3C element, AbstractNodeWrapperW3C child, IDeleteAction deleteAction) {
        throw new IllegalStateException("Unlinked state does not allow delete actions");
    }

    @Override
    public boolean isLinked() {
        return false;
    }

    private void link(AbstractNodeWrapperW3C child, ElementWrapperW3C element) {
        if (child instanceof ElementWrapperW3C) {
            ElementWrapperW3C childWrapperW3c = (ElementWrapperW3C)child;
            childWrapperW3c.link(element);
        }
    }

    @Override
    public IElementWrapper getLinkedElement(ElementWrapperW3C elementWrapperW3C) {
        return null;
    }
}

