/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.dom.w3c.impl.state;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.mule.tooling.core.builder.messageflow.IXmlOrder;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.dom.INodeListWrapper;
import org.mule.tooling.core.dom.INodeWrapper;
import org.mule.tooling.core.dom.w3c.impl.AbstractNodeWrapperW3C;
import org.mule.tooling.core.dom.w3c.impl.ElementWrapperW3C;
import org.mule.tooling.core.dom.w3c.impl.IConfigurableElementW3C;
import org.mule.tooling.core.dom.w3c.impl.NodeListW3C;
import org.mule.tooling.core.dom.w3c.impl.W3CFactory;
import org.mule.tooling.core.dom.w3c.impl.W3CNodeUtils;
import org.mule.tooling.core.dom.w3c.impl.actions.IAddAttributeAction;
import org.mule.tooling.core.dom.w3c.impl.actions.IAddChildAction;
import org.mule.tooling.core.dom.w3c.impl.actions.IDeleteAction;
import org.mule.tooling.core.dom.w3c.impl.state.IElementState;
import org.mule.tooling.core.dom.w3c.impl.state.LinkedStateW3C;
import org.mule.tooling.core.dom.w3c.impl.state.W3CUtils;
import org.w3c.dom.Element;

public class PendingLinkageStateW3C
implements IElementState {
    private ElementWrapperW3C parent;
    private ElementWrapperW3C element;
    private List<IAddAttributeAction> deferredAttributeActions;
    private List<INodeWrapper> elementsToReparent;

    PendingLinkageStateW3C(ElementWrapperW3C parent, ElementWrapperW3C element, List<IAddAttributeAction> deferredAttributeActions, List<INodeWrapper> elementsToReparent) {
        this.parent = parent;
        this.element = element;
        this.deferredAttributeActions = deferredAttributeActions;
        this.elementsToReparent = elementsToReparent;
    }

    public static PendingLinkageStateW3C create(ElementWrapperW3C parent, ElementWrapperW3C element) {
        return new PendingLinkageStateW3C(parent, element, new ArrayList<IAddAttributeAction>(), new ArrayList<INodeWrapper>());
    }

    public static PendingLinkageStateW3C createWithElements(ElementWrapperW3C parent, ElementWrapperW3C element, List<INodeWrapper> elementsToReparent) {
        return new PendingLinkageStateW3C(parent, element, new ArrayList<IAddAttributeAction>(), elementsToReparent);
    }

    @Override
    public int getChildElementsSize(ElementWrapperW3C element) {
        return this.elementsToReparent.size();
    }

    @Override
    public INodeListWrapper<IElementWrapper> getChildElements(ElementWrapperW3C elementWrapperW3C) {
        ArrayList<Element> w3cElements = new ArrayList<Element>(this.elementsToReparent.size());
        for (INodeWrapper child : this.elementsToReparent) {
            if (!(child instanceof ElementWrapperW3C)) continue;
            w3cElements.add(((ElementWrapperW3C)child).getNode());
        }
        return W3CFactory.wrapChildElements(new NodeListW3C(w3cElements), elementWrapperW3C.getSchemaLocationLookup());
    }

    @Override
    public void handleAttributeRequest(ElementWrapperW3C elementWrapperW3C, IAddAttributeAction addAttributeAction) {
        boolean added = addAttributeAction.addAttribute();
        if (added) {
            this.deferredAttributeActions.add(addAttributeAction);
        }
    }

    @Override
    public void handleAddRequest(ElementWrapperW3C element, AbstractNodeWrapperW3C child, IAddChildAction addAction) {
        boolean shouldDelegateToParent;
        boolean bl = shouldDelegateToParent = element.getConfiguration().getMinimumChildElementsToShow() > this.elementsToReparent.size() + 1;
        if (!shouldDelegateToParent) {
            this.linkToParent();
            for (INodeWrapper elementToReparent : this.elementsToReparent) {
                this.reparent(elementToReparent, element);
            }
            for (IAddAttributeAction deferredAddAction : this.deferredAttributeActions) {
                deferredAddAction.addNamespace();
            }
            addAction.apply(element);
            if (child instanceof ElementWrapperW3C) {
                ElementWrapperW3C childWrapperW3c = (ElementWrapperW3C)child;
                childWrapperW3c.link(element);
            }
        } else {
            this.elementsToReparent.add(child);
            this.parent.getState().handleAddRequest(this.parent, child, addAction);
        }
    }

    private void linkToParent() {
        if (this.elementsToReparent.isEmpty()) {
            IConfigurableElementW3C configuration = this.element.getConfiguration();
            IElementWrapper beforeElement = configuration.getNextLinkedElement();
            if (beforeElement != null) {
                W3CNodeUtils.insertBefore(this.parent.getNode(), this.element, (AbstractNodeWrapperW3C)((Object)beforeElement));
            } else if (IXmlOrder.isValidXmlOrder(this.element.getXmlOrder())) {
                NavigableMap<Integer, List<ElementWrapperW3C>> childrenWithXmlOrder = W3CUtils.getChildElementsByXmlOrder(this.parent);
                Map.Entry<Integer, List<ElementWrapperW3C>> higherEntry = childrenWithXmlOrder.higherEntry(this.element.getXmlOrder());
                if (higherEntry != null) {
                    W3CNodeUtils.insertBefore(this.parent.getNode(), this.element, higherEntry.getValue().get(0));
                } else {
                    W3CNodeUtils.appendChild(this.parent.getNode(), this.element);
                }
            } else {
                W3CNodeUtils.appendChild(this.parent.getNode(), this.element);
            }
        } else {
            int insertionIndexForParent = this.parent.getChildElements().indexOf((IElementWrapper)this.elementsToReparent.get(0));
            IElementWrapper beforeElement = this.parent.getChildElements().get(insertionIndexForParent);
            W3CNodeUtils.insertBefore(this.parent.getNode(), this.element, (AbstractNodeWrapperW3C)((Object)beforeElement));
        }
        W3CNodeUtils.addNamespace(((ElementWrapperW3C)this.element.getDocument().getRootElement()).getNode(), this.element.getQName(), this.element.getSchemaLocationLookup());
        this.element.link(this.parent);
    }

    private void reparent(INodeWrapper elementToReparent, ElementWrapperW3C newParent) {
        IElementWrapper oldParent = elementToReparent.getParent();
        oldParent.removeChild(elementToReparent);
        W3CNodeUtils.appendChild(newParent.getNode(), (AbstractNodeWrapperW3C)elementToReparent);
        if (elementToReparent instanceof ElementWrapperW3C) {
            ((ElementWrapperW3C)elementToReparent).link(newParent);
        }
    }

    @Override
    public void handleDeleteRequest(ElementWrapperW3C element, AbstractNodeWrapperW3C child, IDeleteAction deleteAction) {
        if (!this.elementsToReparent.contains(child)) {
            throw new IllegalArgumentException("element " + String.valueOf(child) + " not handled by node pending linkage " + String.valueOf(element));
        }
        this.parent.getState().handleDeleteRequest(this.parent, child, deleteAction);
        this.elementsToReparent.remove(child);
    }

    @Override
    public IElementState transition(ElementWrapperW3C parent, ElementWrapperW3C element) {
        return new LinkedStateW3C(parent.getNode());
    }

    @Override
    public boolean isLinked() {
        return false;
    }

    @Override
    public IElementWrapper getLinkedElement(ElementWrapperW3C elementWrapperW3C) {
        return null;
    }
}

