/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.dom.w3c.impl.state;

import java.util.ArrayList;
import java.util.List;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.dom.INodeListWrapper;
import org.mule.tooling.core.dom.INodeWrapper;
import org.mule.tooling.core.dom.w3c.impl.AbstractNodeWrapperW3C;
import org.mule.tooling.core.dom.w3c.impl.ElementWrapperW3C;
import org.mule.tooling.core.dom.w3c.impl.W3CFactory;
import org.mule.tooling.core.dom.w3c.impl.W3CNodeUtils;
import org.mule.tooling.core.dom.w3c.impl.actions.IAddAttributeAction;
import org.mule.tooling.core.dom.w3c.impl.actions.IAddChildAction;
import org.mule.tooling.core.dom.w3c.impl.actions.IDeleteAction;
import org.mule.tooling.core.dom.w3c.impl.state.AbstractStateW3C;
import org.mule.tooling.core.dom.w3c.impl.state.IElementState;
import org.mule.tooling.core.dom.w3c.impl.state.PendingLinkageStateW3C;
import org.mule.tooling.core.dom.w3c.impl.state.UnlinkedStateW3C;
import org.w3c.dom.Element;

public class LinkedStateW3C
extends AbstractStateW3C
implements IElementState {
    private Element parentNode;
    private List<INodeWrapper> reparentedElements;

    public LinkedStateW3C(Element parentNode) {
        this.parentNode = parentNode;
    }

    @Override
    public int getChildElementsSize(ElementWrapperW3C element) {
        return element.getChildElements().size();
    }

    @Override
    public INodeListWrapper<IElementWrapper> getChildElements(ElementWrapperW3C elementWrapperW3C) {
        return W3CFactory.wrapChildElements(elementWrapperW3C.getNode().getChildNodes(), elementWrapperW3C.getSchemaLocationLookup());
    }

    @Override
    public void handleAttributeRequest(ElementWrapperW3C elementWrapperW3C, IAddAttributeAction addAttributeAction) {
        boolean added = addAttributeAction.addAttribute();
        if (added) {
            addAttributeAction.addNamespace();
        }
    }

    @Override
    public void handleAddRequest(ElementWrapperW3C element, AbstractNodeWrapperW3C child, IAddChildAction addAction) {
        addAction = this.getOrderedAction(element, child, addAction, true);
        addAction.apply(element);
        if (child instanceof ElementWrapperW3C) {
            ElementWrapperW3C childWrapperW3c = (ElementWrapperW3C)child;
            childWrapperW3c.link(element);
        }
    }

    @Override
    public IElementState transition(ElementWrapperW3C parent, ElementWrapperW3C element) {
        int childElementsCount;
        ElementWrapperW3C parentWrapper = (ElementWrapperW3C)W3CFactory.wrapLinkedElement(this.parentNode, element.getSchemaLocationLookup());
        IElementState newState = this.reparentedElements != null ? PendingLinkageStateW3C.createWithElements(parentWrapper, element, this.reparentedElements) : ((childElementsCount = W3CFactory.wrapChildElements(element.getNode().getChildNodes(), element.getSchemaLocationLookup()).size()) < element.getConfiguration().getMinimumChildElementsToShow() ? PendingLinkageStateW3C.create(parentWrapper, element) : new UnlinkedStateW3C());
        return newState;
    }

    @Override
    public void handleDeleteRequest(ElementWrapperW3C element, AbstractNodeWrapperW3C child, IDeleteAction deleteAction) {
        deleteAction.apply(element);
        if (child instanceof ElementWrapperW3C) {
            ElementWrapperW3C childWrapperW3c = (ElementWrapperW3C)child;
            childWrapperW3c.unlink();
        }
        if (!element.shouldShowElement()) {
            ElementWrapperW3C parent = (ElementWrapperW3C)element.getParent();
            if (this.getChildElementsSize(element) > 0) {
                this.reparentedElements = this.reparentChildElements(element, parent);
            }
            this.removeChild(parent, element);
        }
    }

    private List<INodeWrapper> reparentChildElements(ElementWrapperW3C source, IElementWrapper destination) {
        int indexToAddChildren = destination.getChildElements().indexOf(source);
        INodeListWrapper<IElementWrapper> childElements = source.getChildElements();
        ArrayList<INodeWrapper> elementsToReparent = new ArrayList<INodeWrapper>(childElements.size());
        for (IElementWrapper childElement : childElements) {
            this.removeChild(source, childElement);
            destination.add(indexToAddChildren, childElement);
            elementsToReparent.add(childElement);
            ++indexToAddChildren;
        }
        return elementsToReparent;
    }

    private void removeChild(ElementWrapperW3C source, IElementWrapper childElement) {
        ElementWrapperW3C childElementW3c = (ElementWrapperW3C)childElement;
        W3CNodeUtils.removeChild(source.getNode(), childElementW3c);
        childElementW3c.unlink();
    }

    @Override
    public boolean isLinked() {
        return true;
    }

    @Override
    public IElementWrapper getLinkedElement(ElementWrapperW3C elementWrapperW3C) {
        return elementWrapperW3C;
    }
}

