/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.dom.w3c.impl.actions.impl;

import javax.xml.namespace.QName;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.mule.tooling.core.dom.QNameUtils;
import org.mule.tooling.core.dom.w3c.impl.W3CNodeUtils;
import org.mule.tooling.core.dom.w3c.impl.actions.IAddAttributeAction;
import org.mule.tooling.core.runtime.server.ISchemaLocationLookup;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class AddAttributeByQNameAction
implements IAddAttributeAction {
    private static final String NEW_LINE = "\n";
    private static final String XML_NEW_LINE = "&#10;";
    private static final String CHARACTER_CARRIAGE_RETURN = "\r";
    private final Element element;
    private final QName name;
    private final String value;
    private final ISchemaLocationLookup schemaLocationLookup;

    public AddAttributeByQNameAction(Element element, QName name, String value, ISchemaLocationLookup schemaLocationLookup) {
        this.element = element;
        this.name = name;
        this.value = value;
        this.schemaLocationLookup = schemaLocationLookup;
    }

    @Override
    public boolean addAttribute() {
        String localPart;
        boolean added = false;
        String namespaceURI = this.name.getNamespaceURI();
        Attr attribute = this.element.getAttributeNodeNS(namespaceURI, localPart = this.name.getLocalPart());
        if (attribute != null && this.value == null) {
            this.element.getAttributes().removeNamedItemNS(namespaceURI, localPart);
        } else if (this.value != null) {
            this.element.setAttributeNS(namespaceURI, QNameUtils.toQualifiedName(this.name), this.value);
            Attr attr = this.element.getAttributeNodeNS(namespaceURI, localPart);
            if (attr instanceof AttrImpl) {
                ((AttrImpl)attr).setValueSource(attr.getValue().replace(CHARACTER_CARRIAGE_RETURN, "").replace(NEW_LINE, XML_NEW_LINE));
                this.element.setAttributeNodeNS(attr);
            }
            added = true;
        }
        return added;
    }

    @Override
    public void addNamespace() {
        Element rootElement = this.element.getOwnerDocument().getDocumentElement();
        W3CNodeUtils.addNamespace(rootElement, this.name, this.schemaLocationLookup);
    }
}

