/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.dom.w3c.impl.actions.impl;

import javax.xml.namespace.QName;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.mule.tooling.core.dom.w3c.impl.W3CNodeUtils;
import org.mule.tooling.core.dom.w3c.impl.actions.IAddAttributeAction;
import org.mule.tooling.core.runtime.server.ISchemaLocationLookup;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class AddAttributeByNameAction
implements IAddAttributeAction {
    private static final String CHARACTER_CARRIAGE_RETURN = "\r";
    private static final String NEW_LINE = "\n";
    private static final String XML_NEW_LINE = "&#10;";
    private final Element element;
    private final String attributeName;
    private final String value;
    private ISchemaLocationLookup schemaLocationLookup;

    public AddAttributeByNameAction(Element element, String attributeName, String value, ISchemaLocationLookup schemaLocationLookup) {
        this.element = element;
        this.attributeName = attributeName;
        this.value = value;
        this.schemaLocationLookup = schemaLocationLookup;
    }

    @Override
    public boolean addAttribute() {
        boolean added = false;
        Attr attribute = this.element.getAttributeNode(this.attributeName);
        if (attribute != null && this.value == null) {
            this.element.getAttributes().removeNamedItem(this.attributeName);
        } else if (this.value != null) {
            this.element.setAttribute(this.attributeName, this.value);
            Attr attr = this.element.getAttributeNode(this.attributeName);
            if (attr instanceof AttrImpl) {
                ((AttrImpl)attr).setValueSource(attr.getValue().replace(CHARACTER_CARRIAGE_RETURN, "").replace(NEW_LINE, XML_NEW_LINE));
                this.element.setAttributeNode(attr);
            }
            added = true;
        }
        return added;
    }

    @Override
    public void addNamespace() {
        String prefix;
        String namespaceUri;
        boolean hasPrefix;
        int indexOfColon = this.attributeName.indexOf(58);
        boolean bl = hasPrefix = indexOfColon > 0;
        if (hasPrefix && (namespaceUri = this.schemaLocationLookup.getNamespaceUriByPrefix(prefix = this.attributeName.substring(0, indexOfColon))) != null) {
            String localPart = this.attributeName.substring(indexOfColon + 1);
            Element rootElement = this.element.getOwnerDocument().getDocumentElement();
            QName qName = new QName(namespaceUri, localPart, prefix);
            W3CNodeUtils.addNamespace(rootElement, qName, this.schemaLocationLookup);
        }
    }
}

