/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.dom.w3c.impl;

import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.mule.tooling.core.dom.w3c.impl.AbstractNodeWrapperW3C;
import org.mule.tooling.core.runtime.server.ISchemaLocationLookup;
import org.mule.tooling.utils.reflect.ReflectionUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class W3CNodeUtils {
    private static final String NS_DECLARATION_PREFIX = "xmlns";
    private static final String SCHEMA_LOCATION_PREFIX = "xmlns:xsi";
    private static final String SCHEMA_LOCATION_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String SCHEMA_LOCATION_ATT_NAME = "xsi:schemaLocation";

    public static void appendChild(Element element, AbstractNodeWrapperW3C childNode) {
        W3CNodeUtils.appendChild(element, childNode.getNode());
    }

    public static void insertBefore(Element element, AbstractNodeWrapperW3C childNode, AbstractNodeWrapperW3C beforeNode) {
        W3CNodeUtils.insertBefore(element, childNode.getNode(), beforeNode.getNode());
    }

    public static void removeChild(Element element, AbstractNodeWrapperW3C childNode) {
        W3CNodeUtils.removeChild(element, childNode.getNode());
    }

    public static boolean hasContent(Element element) {
        return element.hasChildNodes();
    }

    public static void markAsEmpty(Element element) {
        if (element instanceof IDOMElement) {
            IDOMElement domElement = (IDOMElement)element;
            domElement.setEmptyTag(true);
        }
    }

    public static void addNamespace(Element rootElement, QName qName, ISchemaLocationLookup schemaLocationLookup) {
        if (StringUtils.isNotBlank((String)qName.getPrefix())) {
            W3CNodeUtils.addNamespaceDeclaration(qName, rootElement);
            W3CNodeUtils.addSchemaLocation(schemaLocationLookup, qName, rootElement);
        }
    }

    private static void addSchemaLocation(ISchemaLocationLookup schemaLocationLookup, QName qName, Element rootElement) {
        String schemaLocation = schemaLocationLookup.getSchemaLocationByUri(qName.getNamespaceURI());
        if (StringUtils.isNotBlank((String)schemaLocation)) {
            String schemaLocationContents;
            String string = schemaLocationContents = rootElement.getAttributeNode(SCHEMA_LOCATION_ATT_NAME) != null ? rootElement.getAttribute(SCHEMA_LOCATION_ATT_NAME) : "";
            if (!schemaLocationContents.contains(schemaLocation)) {
                StringBuilder schemaLocationBuilder = new StringBuilder(schemaLocationContents);
                if (!schemaLocationContents.isEmpty()) {
                    schemaLocationBuilder.append(System.lineSeparator());
                }
                schemaLocationBuilder.append(qName.getNamespaceURI());
                schemaLocationBuilder.append(" ");
                schemaLocationBuilder.append(schemaLocation);
                rootElement.setAttribute(SCHEMA_LOCATION_PREFIX, SCHEMA_LOCATION_URI);
                rootElement.setAttribute(SCHEMA_LOCATION_ATT_NAME, schemaLocationBuilder.toString());
            }
        }
    }

    private static void addNamespaceDeclaration(QName qName, Element rootElement) {
        String namespaceAttributeName = "xmlns:" + qName.getPrefix();
        Attr namespaceAttribute = rootElement.getAttributeNode(namespaceAttributeName);
        if (namespaceAttribute == null && StringUtils.isNotBlank((String)qName.getNamespaceURI())) {
            namespaceAttribute = rootElement.getOwnerDocument().createAttribute(namespaceAttributeName);
            namespaceAttribute.setValue(qName.getNamespaceURI());
            W3CNodeUtils.prependAttributeReplacing(rootElement, namespaceAttribute);
        }
    }

    public static void prependAttributeReplacing(Element element, Attr newAttribute) {
        IDOMModel domModel = element instanceof IDOMElement ? ((IDOMElement)element).getModel() : null;
        Object requester = new Object();
        NamedNodeMap attributes = element.getAttributes();
        if (attributes.getLength() == 0) {
            element.setAttributeNode(newAttribute);
        } else {
            if (domModel != null) {
                domModel.beginRecording(requester);
            }
            Attr lastAttrCopy = (Attr)attributes.item(attributes.getLength() - 1).cloneNode(true);
            Attr firstAttr = (Attr)attributes.item(0);
            String previousName = firstAttr.getName();
            String previousValue = firstAttr.getValue();
            W3CNodeUtils.replaceAttributeProperties(firstAttr, newAttribute.getName(), newAttribute.getValue());
            int i = 1;
            while (i < attributes.getLength()) {
                Attr current = (Attr)attributes.item(i);
                String _previousName = current.getName();
                String _previousValue = current.getValue();
                W3CNodeUtils.replaceAttributeProperties(current, previousName, previousValue);
                previousName = _previousName;
                previousValue = _previousValue;
                ++i;
            }
            element.setAttributeNode(lastAttrCopy);
            if (domModel != null) {
                domModel.endRecording(requester);
            }
        }
    }

    private static void replaceAttributeProperties(Attr attribute, String name, String value) {
        W3CNodeUtils.setAttributeName(attribute, name);
        attribute.setValue(value);
    }

    private static void setAttributeName(Attr attr, String name) {
        ReflectionUtils.invokeSetter((String)"name", String.class, (Object)name, (Object)attr);
        ReflectionUtils.invokeMethod((String)"notifyNameChanged", (Object)attr);
    }

    private static void appendChild(Element element, Node node) {
        Document document = element.getOwnerDocument();
        IDOMModel domModel = element instanceof IDOMElement ? ((IDOMElement)element).getModel() : null;
        Object requester = new Object();
        try {
            boolean shouldFormat;
            if (domModel != null) {
                domModel.aboutToChangeModel();
                domModel.beginRecording(requester);
            }
            int level = W3CNodeUtils.level(element);
            Node lastChild = W3CNodeUtils.lastChild(element.getChildNodes());
            boolean bl = shouldFormat = node instanceof Element || node instanceof Comment;
            if (!W3CNodeUtils.hasContent(element)) {
                if (shouldFormat) {
                    element.appendChild(document.createTextNode(System.lineSeparator().concat(StringUtils.repeat((String)W3CNodeUtils.getIndent(), (int)(level + 1)))));
                }
                element.appendChild(node);
                if (shouldFormat) {
                    element.appendChild(document.createTextNode(System.lineSeparator().concat(StringUtils.repeat((String)W3CNodeUtils.getIndent(), (int)level))));
                }
            } else if (lastChild != null) {
                Node nextSibling = lastChild.getNextSibling();
                if (nextSibling != null) {
                    if (shouldFormat) {
                        element.insertBefore(document.createTextNode(System.lineSeparator().concat(StringUtils.repeat((String)W3CNodeUtils.getIndent(), (int)(level + 1)))), nextSibling);
                    }
                    element.insertBefore(node, nextSibling);
                    boolean hasLineSeparatorSibling = W3CNodeUtils.checkLineSeparatorSibling(nextSibling);
                    if (!hasLineSeparatorSibling && shouldFormat) {
                        element.appendChild(document.createTextNode(System.lineSeparator()));
                    }
                } else {
                    if (shouldFormat) {
                        element.appendChild(document.createTextNode(System.lineSeparator().concat(StringUtils.repeat((String)W3CNodeUtils.getIndent(), (int)(level + 1)))));
                    }
                    element.appendChild(node);
                    if (shouldFormat) {
                        element.appendChild(document.createTextNode(System.lineSeparator().concat(StringUtils.repeat((String)W3CNodeUtils.getIndent(), (int)level))));
                    }
                }
            } else {
                Node firstChild = element.getFirstChild();
                if (shouldFormat) {
                    element.insertBefore(document.createTextNode(System.lineSeparator().concat(StringUtils.repeat((String)W3CNodeUtils.getIndent(), (int)(level + 1)))), firstChild);
                }
                element.insertBefore(node, firstChild);
                boolean hasLineSeparatorSibling = W3CNodeUtils.checkLineSeparatorSibling(firstChild);
                if (!hasLineSeparatorSibling && shouldFormat) {
                    element.insertBefore(document.createTextNode(System.lineSeparator()), firstChild);
                }
            }
        }
        finally {
            if (domModel != null) {
                domModel.changedModel();
                domModel.endRecording(requester);
            }
        }
    }

    private static void insertBefore(Element element, Node newChild, Node refChild) {
        Document document = element.getOwnerDocument();
        IDOMModel domModel = element instanceof IDOMElement ? ((IDOMElement)element).getModel() : null;
        Object requester = new Object();
        try {
            if (domModel != null) {
                domModel.aboutToChangeModel();
            }
            domModel.beginRecording(requester);
            int level = W3CNodeUtils.level(element);
            element.insertBefore(newChild, refChild);
            element.insertBefore(document.createTextNode(System.lineSeparator()), refChild);
            element.insertBefore(document.createTextNode(StringUtils.repeat((String)W3CNodeUtils.getIndent(), (int)(level + 1))), refChild);
        }
        finally {
            if (domModel != null) {
                domModel.changedModel();
            }
            domModel.endRecording(requester);
        }
    }

    public static void removeChild(Element element, Node oldChild) {
        IDOMModel domModel = element instanceof IDOMElement ? ((IDOMElement)element).getModel() : null;
        Object requester = new Object();
        try {
            if (domModel != null) {
                domModel.aboutToChangeModel();
                domModel.beginRecording(requester);
            }
            while (oldChild != null) {
                Node previousSibling = oldChild.getPreviousSibling();
                element.removeChild(oldChild);
                if (!(previousSibling instanceof Text) || !StringUtils.isBlank((String)previousSibling.getNodeValue())) {
                    if (previousSibling instanceof Text) {
                        previousSibling.setNodeValue(previousSibling.getNodeValue().replaceAll("\\s+$", ""));
                    }
                    break;
                }
                oldChild = previousSibling;
            }
        }
        finally {
            if (domModel != null) {
                domModel.changedModel();
                domModel.endRecording(requester);
            }
        }
    }

    private static int level(Element element) {
        int counter = 0;
        Node node = element;
        while ((node = node.getParentNode()) != null) {
            ++counter;
        }
        return counter - 1;
    }

    private static Node lastChild(NodeList childNodes) {
        int index = 0;
        Node lastChild = null;
        while (index < childNodes.getLength()) {
            Node item = childNodes.item(index);
            ++index;
            short nodeType = item.getNodeType();
            if (1 != nodeType && 8 != nodeType) continue;
            lastChild = item;
        }
        return lastChild;
    }

    private static boolean checkLineSeparatorSibling(Node node) {
        Node sibling = node;
        boolean hasLineSeparatorSibling = false;
        while (sibling != null) {
            if (3 == sibling.getNodeType() && sibling.getNodeValue().contains(System.lineSeparator())) {
                hasLineSeparatorSibling = true;
                break;
            }
            sibling = sibling.getNextSibling();
        }
        return hasLineSeparatorSibling;
    }

    private static String getIndent() {
        String indent = "";
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.wst.xml.core");
        String indentationChar = preferences.get("indentationChar", "");
        if (indentationChar != null && indentationChar.equals("space")) {
            int size = preferences.getInt("indentationSize", 4);
            indent = StringUtils.leftPad((String)indent, (int)size);
        } else {
            indent = "\t";
        }
        return indent;
    }
}

