/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.dom.w3c.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang.ArrayUtils;
import org.mule.tooling.core.dom.INodeListWrapper;
import org.mule.tooling.core.dom.INodeWrapper;
import org.mule.tooling.core.dom.w3c.impl.W3CFactory;
import org.mule.tooling.core.runtime.server.ISchemaLocationLookup;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class NodeListWrapperW3C
implements INodeListWrapper<INodeWrapper> {
    private NodeList nodeList;
    private ISchemaLocationLookup schemaLocationLookup;

    protected NodeListWrapperW3C(NodeList nodeList, ISchemaLocationLookup schemaLocationLookup) {
        this.nodeList = nodeList;
        this.schemaLocationLookup = schemaLocationLookup;
    }

    @Override
    public int size() {
        return new ElementCounter(this.iterator()).size();
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    @Override
    public INodeWrapper get(int index) {
        int currentIndex = 0;
        for (INodeWrapper element : this) {
            if (currentIndex == index) {
                return element;
            }
            ++currentIndex;
        }
        return null;
    }

    @Override
    public Iterator<INodeWrapper> iterator() {
        return new NodeListIterator(this.nodeList, this.schemaLocationLookup);
    }

    @Override
    public INodeWrapper getByName(String attributeName) {
        for (INodeWrapper element : this) {
            if (!attributeName.equals(element.getName())) continue;
            return element;
        }
        return null;
    }

    @Override
    public int indexOf(INodeWrapper elementWrapper) {
        Iterator<INodeWrapper> iterator = this.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            INodeWrapper element = iterator.next();
            if (element.equals(elementWrapper)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public String toString() {
        return this.nodeList.toString();
    }

    private static final class ElementCounter {
        private int size = 0;

        public ElementCounter(Iterator<INodeWrapper> iterator) {
            while (iterator.hasNext()) {
                iterator.next();
                ++this.size;
            }
        }

        public int size() {
            return this.size;
        }
    }

    private static final class NodeListIterator
    implements Iterator<INodeWrapper> {
        private int index;
        private Node node;
        private NodeList nodeList;
        private ISchemaLocationLookup schemaLocationLookup;
        private static final int[] TYPES = new int[]{1, 3, 4, 8};

        public NodeListIterator(NodeList nodeList, ISchemaLocationLookup schemaLocationLookup) {
            this.nodeList = nodeList;
            this.schemaLocationLookup = schemaLocationLookup;
        }

        @Override
        public boolean hasNext() {
            if (this.node == null) {
                this.node = this.findNextElement();
            }
            return this.node != null;
        }

        @Override
        public INodeWrapper next() {
            INodeWrapper wrapper;
            if (this.node != null) {
                wrapper = this.wrap(this.node);
                this.node = null;
            } else {
                Node nextElement = this.findNextElement();
                if (nextElement == null) {
                    throw new NoSuchElementException();
                }
                wrapper = this.wrap(nextElement);
            }
            return wrapper;
        }

        private INodeWrapper wrap(Node nextElement) {
            return switch (nextElement.getNodeType()) {
                case 1 -> W3CFactory.wrapLinkedElement((Element)nextElement, this.schemaLocationLookup);
                case 3 -> W3CFactory.wrapElement((Text)nextElement, this.schemaLocationLookup);
                case 4 -> W3CFactory.wrapElement((CDATASection)nextElement, this.schemaLocationLookup);
                case 8 -> W3CFactory.wrapCommentNode((Comment)nextElement, this.schemaLocationLookup);
                default -> null;
            };
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove method is not implemented yet!!!");
        }

        private Node findNextElement() {
            Node node = null;
            while (this.index < this.nodeList.getLength()) {
                Node item = this.nodeList.item(this.index);
                ++this.index;
                if (!ArrayUtils.contains((int[])TYPES, (int)item.getNodeType())) continue;
                node = item;
                break;
            }
            return node;
        }
    }
}

