/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.dom.w3c.impl;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.mule.tooling.core.dom.IAttributeListWrapper;
import org.mule.tooling.core.dom.IAttributeWrapper;
import org.mule.tooling.core.dom.IConfigurableElement;
import org.mule.tooling.core.dom.IDocumentWrapper;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.dom.INodeListWrapper;
import org.mule.tooling.core.dom.INodeWrapper;
import org.mule.tooling.core.dom.location.IElementLocation;
import org.mule.tooling.core.dom.location.impl.DefaultAbsoluteLocation;
import org.mule.tooling.core.dom.w3c.impl.AbstractNodeWrapperW3C;
import org.mule.tooling.core.dom.w3c.impl.DefaultConfigurableElementW3C;
import org.mule.tooling.core.dom.w3c.impl.IConfigurableElementW3C;
import org.mule.tooling.core.dom.w3c.impl.NodeListW3C;
import org.mule.tooling.core.dom.w3c.impl.W3CFactory;
import org.mule.tooling.core.dom.w3c.impl.W3CNodeUtils;
import org.mule.tooling.core.dom.w3c.impl.actions.impl.AddAttributeByNameAction;
import org.mule.tooling.core.dom.w3c.impl.actions.impl.AddAttributeByQNameAction;
import org.mule.tooling.core.dom.w3c.impl.actions.impl.AppendChild;
import org.mule.tooling.core.dom.w3c.impl.actions.impl.InsertAfter;
import org.mule.tooling.core.dom.w3c.impl.actions.impl.InsertAt;
import org.mule.tooling.core.dom.w3c.impl.actions.impl.InsertBefore;
import org.mule.tooling.core.dom.w3c.impl.actions.impl.RemoveChild;
import org.mule.tooling.core.dom.w3c.impl.state.IElementState;
import org.mule.tooling.core.dom.w3c.impl.state.PendingLinkageStateW3C;
import org.mule.tooling.core.dom.w3c.impl.state.UnlinkedStateW3C;
import org.mule.tooling.core.dom.w3c.impl.state.VirtualNodeStateW3C;
import org.mule.tooling.core.runtime.server.ISchemaLocationLookup;
import org.mule.tooling.core.xml.XmlFactoryUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ElementWrapperW3C
extends AbstractNodeWrapperW3C
implements IElementWrapper,
IConfigurableElement {
    private static final String ILLEGAL_INSTANCE_TYPE_MESSAGE = "Not an instance of AbstractNodeWrapperW3C: ";
    private static final String ORG_MULE_TOOLING_XMLORDER = "org.mule.tooling.xmlorder";
    private Element element;
    private IElementState state;
    private IConfigurableElementW3C configuration;
    private ISchemaLocationLookup schemaLocationLookup;

    protected ElementWrapperW3C(Element element, ISchemaLocationLookup schemaLocationLookup) {
        this(element, schemaLocationLookup, new UnlinkedStateW3C());
    }

    protected ElementWrapperW3C(Element element, ISchemaLocationLookup schemaLocationLookup, IElementState state) {
        super(element);
        this.state = state;
        this.element = element;
        this.schemaLocationLookup = schemaLocationLookup;
        this.configuration = new DefaultConfigurableElementW3C();
    }

    public IConfigurableElementW3C getConfiguration() {
        return this.configuration;
    }

    public IElementState getState() {
        return this.state;
    }

    public void link(ElementWrapperW3C parent) {
        this.state = this.state.transition(parent, this);
    }

    public void unlink() {
        this.state = this.state.transition(null, this);
    }

    @Override
    public void setQName(QName qname) {
        this.getNode().setPrefix(qname.getPrefix());
        Element rootElement = ((ElementWrapperW3C)this.getDocument().getRootElement()).getNode();
        W3CNodeUtils.addNamespace(rootElement, qname, this.schemaLocationLookup);
    }

    @Override
    public void setMinimumChildElementsToShow(int childElementCount) {
        this.configuration.setMinimumChildElementsToShow(childElementCount);
    }

    @Override
    public void setIntermediateNodeConfig(IElementWrapper parent, IElementWrapper child) {
        ArrayList<INodeWrapper> children = new ArrayList<INodeWrapper>();
        children.add(child);
        this.state = PendingLinkageStateW3C.createWithElements((ElementWrapperW3C)parent, this, children);
    }

    @Override
    public void setVirtualNodeConfig(IElementWrapper parent, List<IElementWrapper> childElements) {
        this.state = new VirtualNodeStateW3C((ElementWrapperW3C)parent, this, childElements);
    }

    @Override
    public void setNextSibling(IElementWrapper element) {
        this.configuration.setNextSibling(element);
    }

    @Override
    public void setPreviousSibling(IElementWrapper element) {
        this.configuration.setPreviousSibling(element);
    }

    @Override
    public void setXmlOrder(int xmlOrder) {
        this.element.setUserData(ORG_MULE_TOOLING_XMLORDER, xmlOrder, null);
    }

    public int getXmlOrder() {
        Object userData = this.element.getUserData(ORG_MULE_TOOLING_XMLORDER);
        if (userData == null) {
            return -1;
        }
        return (Integer)userData;
    }

    @Override
    public String getName() {
        return this.element.getLocalName();
    }

    @Override
    public String getTagName() {
        return this.element.getNodeName();
    }

    @Override
    public String getText() {
        return this.getNodeText();
    }

    @Override
    public IElementLocation getLocation() {
        IDOMElement domElement = (IDOMElement)this.element;
        return new DefaultAbsoluteLocation(domElement.getStartOffset(), domElement.getEndOffset());
    }

    @Override
    public String getNamespacePrefix() {
        return this.getQName().getPrefix();
    }

    @Override
    public String getNamespaceURI() {
        return this.getQName().getNamespaceURI();
    }

    @Override
    public IDocumentWrapper getDocument() {
        return W3CFactory.wrapDocument(this.element.getOwnerDocument(), this.schemaLocationLookup);
    }

    @Override
    public String asXML() {
        String result = "";
        try {
            DOMSource domSource = new DOMSource(this.element);
            StringWriter stringWriter = new StringWriter();
            TransformerFactory transformerFactory = XmlFactoryUtils.createSecureTransformerFactory();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(domSource, new StreamResult(stringWriter));
            result = stringWriter.toString();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public IElementWrapper createCopy() {
        return W3CFactory.wrapLinkedElement((Element)this.element.cloneNode(true), this.schemaLocationLookup);
    }

    @Override
    public IElementWrapper getParent() {
        IElementWrapper parent = null;
        Node parentNode = this.element.getParentNode();
        if (parentNode instanceof Element) {
            parent = W3CFactory.wrapLinkedElement((Element)parentNode, this.schemaLocationLookup);
        }
        return parent;
    }

    @Override
    public IAttributeWrapper getAttribute(String name) {
        return this.getAttributes().getByName(name);
    }

    @Override
    public IAttributeWrapper getAttribute(QName qName) {
        return this.getAttributes().getByName(qName);
    }

    @Override
    public String getAttributeValue(String name) {
        IAttributeWrapper attribute = this.getAttributes().getByName(name);
        return attribute != null ? attribute.getText() : null;
    }

    @Override
    public void add(INodeWrapper childNode) {
        if (!(childNode instanceof AbstractNodeWrapperW3C)) {
            throw new IllegalArgumentException(ILLEGAL_INSTANCE_TYPE_MESSAGE + String.valueOf(childNode));
        }
        AbstractNodeWrapperW3C w3cWrapper = (AbstractNodeWrapperW3C)childNode;
        this.getState().handleAddRequest(this, w3cWrapper, new AppendChild(this, w3cWrapper, this.schemaLocationLookup));
    }

    @Override
    public void addBefore(INodeWrapper childNode, INodeWrapper beforeNode) {
        if (!(childNode instanceof AbstractNodeWrapperW3C) || !(beforeNode instanceof AbstractNodeWrapperW3C)) {
            throw new IllegalArgumentException(ILLEGAL_INSTANCE_TYPE_MESSAGE + String.valueOf(!(childNode instanceof AbstractNodeWrapperW3C) ? childNode : beforeNode));
        }
        AbstractNodeWrapperW3C beforeWrapper = (AbstractNodeWrapperW3C)beforeNode;
        AbstractNodeWrapperW3C w3cWrapper = (AbstractNodeWrapperW3C)childNode;
        this.getState().handleAddRequest(this, w3cWrapper, new InsertBefore(this, w3cWrapper, beforeWrapper, this.schemaLocationLookup));
    }

    @Override
    public void add(int index, INodeWrapper childNode) {
        if (!(childNode instanceof AbstractNodeWrapperW3C)) {
            throw new IllegalArgumentException(ILLEGAL_INSTANCE_TYPE_MESSAGE + String.valueOf(childNode));
        }
        AbstractNodeWrapperW3C w3cWrapper = (AbstractNodeWrapperW3C)childNode;
        this.getState().handleAddRequest(this, w3cWrapper, new InsertAt(this, index, w3cWrapper, this.schemaLocationLookup));
    }

    @Override
    public void addAfter(INodeWrapper childNode, INodeWrapper afterNode) {
        if (!(childNode instanceof AbstractNodeWrapperW3C) || !(afterNode instanceof AbstractNodeWrapperW3C)) {
            throw new IllegalArgumentException(ILLEGAL_INSTANCE_TYPE_MESSAGE + String.valueOf(!(childNode instanceof AbstractNodeWrapperW3C) ? childNode : afterNode));
        }
        AbstractNodeWrapperW3C childW3cWrapper = (AbstractNodeWrapperW3C)childNode;
        AbstractNodeWrapperW3C afterNodeWrapper = (AbstractNodeWrapperW3C)afterNode;
        this.getState().handleAddRequest(this, childW3cWrapper, new InsertAfter(this, childW3cWrapper, afterNodeWrapper, this.schemaLocationLookup));
    }

    @Override
    public void removeChild(INodeWrapper oldChild) {
        if (!(oldChild instanceof AbstractNodeWrapperW3C)) {
            throw new IllegalArgumentException(ILLEGAL_INSTANCE_TYPE_MESSAGE + String.valueOf(oldChild));
        }
        AbstractNodeWrapperW3C oldChildW3cWrapper = (AbstractNodeWrapperW3C)oldChild;
        this.getState().handleDeleteRequest(this, oldChildW3cWrapper, new RemoveChild(this, oldChildW3cWrapper));
    }

    @Override
    public void removeAttribute(String name) {
        this.addAttribute(name, null);
    }

    @Override
    public IElementWrapper addAttribute(String name, String value) {
        this.getState().handleAttributeRequest(this, new AddAttributeByNameAction(this.element, name, value, this.schemaLocationLookup));
        return this;
    }

    @Override
    public IElementWrapper addAttribute(QName name, String value) {
        this.getState().handleAttributeRequest(this, new AddAttributeByQNameAction(this.element, name, value, this.schemaLocationLookup));
        return this;
    }

    @Override
    public IElementWrapper getElement(String name) {
        INodeListWrapper<IElementWrapper> childNodes = this.getChildElements();
        for (IElementWrapper currentElement : childNodes) {
            if (!name.equals(currentElement.getName())) continue;
            return currentElement;
        }
        return null;
    }

    @Override
    public IElementWrapper getElement(QName qName) {
        INodeListWrapper<IElementWrapper> childNodes = this.getChildElements();
        for (IElementWrapper currentElement : childNodes) {
            if (!qName.equals(currentElement.getQName())) continue;
            return currentElement;
        }
        return null;
    }

    @Override
    public INodeListWrapper<INodeWrapper> getChildNodes() {
        return W3CFactory.wrapChildNodes(this.element.getChildNodes(), this.schemaLocationLookup);
    }

    @Override
    public INodeListWrapper<IElementWrapper> getChildElements() {
        return this.getNode().getParentNode() != null ? W3CFactory.wrapChildElements(this.element.getChildNodes(), this.schemaLocationLookup) : this.getState().getChildElements(this);
    }

    @Override
    public INodeListWrapper<IElementWrapper> getChildElements(QName qName) {
        ArrayList<Element> elements = new ArrayList<Element>();
        INodeListWrapper<IElementWrapper> childNodes = this.getChildElements();
        for (IElementWrapper currentElement : childNodes) {
            if (!qName.equals(currentElement.getQName())) continue;
            elements.add(((ElementWrapperW3C)currentElement).getNode());
        }
        return W3CFactory.wrapChildElements(new NodeListW3C(elements), this.schemaLocationLookup);
    }

    @Override
    public IAttributeListWrapper getAttributes() {
        return W3CFactory.wrapAttributes(this.element.getAttributes(), this);
    }

    @Override
    public IAttributeListWrapper getNamespaceAttributes() {
        return W3CFactory.wrapNamespaceAttributes(this.element.getAttributes(), this);
    }

    public String toString() {
        return this.element.toString();
    }

    @Override
    public String getScriptText() {
        StringBuilder result = new StringBuilder();
        NodeList childNodes = this.element.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            switch (node.getNodeType()) {
                case 3: {
                    if (StringUtils.isBlank((String)node.getNodeValue())) break;
                    result.append(node.getNodeValue());
                    break;
                }
                case 4: {
                    result.append(node.getNodeValue());
                    break;
                }
            }
            ++i;
        }
        return result.toString();
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public boolean equals(Object objectToTest) {
        if (objectToTest == this) {
            return true;
        }
        if (!(objectToTest instanceof ElementWrapperW3C)) {
            return false;
        }
        ElementWrapperW3C elementWrapperW3C = (ElementWrapperW3C)objectToTest;
        return this.element.equals(elementWrapperW3C.element);
    }

    @Override
    public boolean hasContent() {
        return W3CNodeUtils.hasContent(this.element);
    }

    @Override
    public Element getNode() {
        return this.element;
    }

    public ISchemaLocationLookup getSchemaLocationLookup() {
        return this.schemaLocationLookup;
    }

    private String getNodeText() {
        NodeList childNodes = this.element.getChildNodes();
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            switch (node.getNodeType()) {
                case 3: 
                case 4: 
                case 6: {
                    result.append(node.getNodeValue());
                    break;
                }
            }
            ++i;
        }
        return result.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.getState().getChildElementsSize(this) == 0;
    }

    public boolean shouldShowElement() {
        return this.getState().getChildElementsSize(this) >= this.getConfiguration().getMinimumChildElementsToShow();
    }
}

