/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.dom.w3c.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.dom.INodeListWrapper;
import org.mule.tooling.core.dom.w3c.impl.W3CFactory;
import org.mule.tooling.core.runtime.server.ISchemaLocationLookup;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ElementListWrapperW3C
implements INodeListWrapper<IElementWrapper> {
    private NodeList nodeList;
    private ISchemaLocationLookup schemaLocationLookup;

    protected ElementListWrapperW3C(NodeList nodeList, ISchemaLocationLookup schemaLocationLookup) {
        this.nodeList = nodeList;
        this.schemaLocationLookup = schemaLocationLookup;
    }

    @Override
    public int size() {
        return new ElementCounter(this.iterator()).size();
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    @Override
    public IElementWrapper get(int index) {
        int currentIndex = 0;
        for (IElementWrapper element : this) {
            if (currentIndex == index) {
                return element;
            }
            ++currentIndex;
        }
        return null;
    }

    @Override
    public Iterator<IElementWrapper> iterator() {
        return new NodeListIterator(this.nodeList, this.schemaLocationLookup);
    }

    @Override
    public IElementWrapper getByName(String attributeName) {
        for (IElementWrapper element : this) {
            if (!attributeName.equals(element.getName())) continue;
            return element;
        }
        return null;
    }

    @Override
    public int indexOf(IElementWrapper elementWrapper) {
        Iterator<IElementWrapper> iterator = this.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            IElementWrapper element = iterator.next();
            if (element.equals(elementWrapper)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public String toString() {
        return this.nodeList.toString();
    }

    private static final class ElementCounter {
        private int size = 0;

        public ElementCounter(Iterator<IElementWrapper> iterator) {
            while (iterator.hasNext()) {
                iterator.next();
                ++this.size;
            }
        }

        public int size() {
            return this.size;
        }
    }

    private static final class NodeListIterator
    implements Iterator<IElementWrapper> {
        private static final String STUDIO_COMMENT = "[STUDIO:\"";
        private int index;
        private Node node;
        private NodeList nodeList;
        private ISchemaLocationLookup schemaLocationLookup;

        public NodeListIterator(NodeList nodeList, ISchemaLocationLookup schemaLocationLookup) {
            this.nodeList = nodeList;
            this.schemaLocationLookup = schemaLocationLookup;
        }

        @Override
        public boolean hasNext() {
            if (this.node == null) {
                this.node = this.findNextElement();
            }
            return this.node != null;
        }

        @Override
        public IElementWrapper next() {
            IElementWrapper wrapper;
            if (this.node != null) {
                wrapper = W3CFactory.wrapLinkedElement(this.node, this.schemaLocationLookup);
                this.node = null;
            } else {
                Node nextElement = this.findNextElement();
                if (nextElement == null) {
                    throw new NoSuchElementException();
                }
                wrapper = W3CFactory.wrapLinkedElement(nextElement, this.schemaLocationLookup);
            }
            return wrapper;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove method is not implemented yet!!!");
        }

        private Node findNextElement() {
            Node node = null;
            while (this.index < this.nodeList.getLength()) {
                Node item = this.nodeList.item(this.index);
                ++this.index;
                if (1 == item.getNodeType()) {
                    node = item;
                    break;
                }
                if (8 != item.getNodeType() || !item.getTextContent().contains(STUDIO_COMMENT)) continue;
                node = item;
                break;
            }
            return node;
        }
    }
}

