/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.dom.w3c.impl;

import javax.xml.namespace.QName;
import org.mule.tooling.core.dom.IDocumentWrapper;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.dom.INodeWrapper;
import org.mule.tooling.core.dom.QNameUtils;
import org.mule.tooling.core.dom.w3c.impl.AbstractNodeWrapperW3C;
import org.mule.tooling.core.dom.w3c.impl.W3CFactory;
import org.mule.tooling.core.dom.w3c.impl.W3CNodeUtils;
import org.mule.tooling.core.dom.w3c.impl.state.UnlinkedStateW3C;
import org.mule.tooling.core.runtime.server.ISchemaLocationLookup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DocumentWrapperW3C
implements IDocumentWrapper {
    private static final String DEFAULT_NS_ATTRIBUTE_NAME = "xmlns";
    private Document document;
    private ISchemaLocationLookup schemaLocationLookup;

    protected DocumentWrapperW3C(Document document, ISchemaLocationLookup schemaLocationLookup) {
        this.document = document;
        this.schemaLocationLookup = schemaLocationLookup;
    }

    @Override
    public INodeWrapper createCDATA(String data) {
        return W3CFactory.wrapElement(this.document.createCDATASection(data), this.schemaLocationLookup);
    }

    @Override
    public IElementWrapper getRootElement() {
        Element rootElement = this.doGetRootElement();
        return rootElement != null ? W3CFactory.wrapLinkedElement(rootElement, this.schemaLocationLookup) : null;
    }

    private Element doGetRootElement() {
        Element rootElement = null;
        NodeList nodeList = this.document.getChildNodes();
        int index = 0;
        while (index < nodeList.getLength()) {
            Node node = nodeList.item(index);
            if (1 == node.getNodeType()) {
                rootElement = (Element)node;
            }
            ++index;
        }
        return rootElement;
    }

    @Override
    public String getDefaultNamespaceURI() {
        Element rootElement = this.doGetRootElement();
        String attribute = rootElement != null ? rootElement.getAttribute(DEFAULT_NS_ATTRIBUTE_NAME) : "";
        return attribute.isEmpty() ? null : attribute;
    }

    @Override
    public void add(INodeWrapper element) {
        if (!(element instanceof AbstractNodeWrapperW3C)) {
            throw new IllegalArgumentException("Not an instance of AbstractNodeWrapperW3C: " + String.valueOf(element));
        }
        AbstractNodeWrapperW3C w3cChildNode = (AbstractNodeWrapperW3C)element;
        this.document.appendChild(w3cChildNode.getNode());
    }

    public String toString() {
        return this.document.toString();
    }

    @Override
    public IElementWrapper createElement(QName qName) {
        String tagName = this.isDefaultNamespace(qName) ? qName.getLocalPart() : QNameUtils.toQualifiedName(qName);
        Element newElement = this.document.createElementNS(qName.getNamespaceURI(), tagName);
        W3CNodeUtils.markAsEmpty(newElement);
        return W3CFactory.wrapElement(newElement, this.schemaLocationLookup, new UnlinkedStateW3C());
    }

    @Override
    public INodeWrapper createText(String text) {
        return W3CFactory.wrapElement(this.document.createTextNode(text), this.schemaLocationLookup);
    }

    @Override
    public INodeWrapper createComment(String comment) {
        return W3CFactory.wrapLinkedElement(this.document.createComment(comment), this.schemaLocationLookup);
    }

    private boolean isDefaultNamespace(QName qName) {
        String defaultNamespaceURI = this.getDefaultNamespaceURI();
        boolean isDefaultNamespace = defaultNamespaceURI != null && qName.getNamespaceURI().equals(defaultNamespaceURI);
        return isDefaultNamespace;
    }
}

