/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.dom.w3c.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import org.mule.tooling.core.dom.IAttributeListWrapper;
import org.mule.tooling.core.dom.IAttributeWrapper;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.dom.w3c.impl.W3CFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class AttributeListWrapperW3C
implements IAttributeListWrapper {
    private NamedNodeMap attributes;
    private IElementWrapper parent;
    private boolean filterNamespaces;

    protected AttributeListWrapperW3C(NamedNodeMap attributes, IElementWrapper parent, boolean filterNamespaces) {
        this.attributes = attributes;
        this.parent = parent;
        this.filterNamespaces = filterNamespaces;
    }

    @Override
    public int size() {
        return new AttributeCounter(this.iterator()).size();
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    @Override
    public Iterator<IAttributeWrapper> iterator() {
        return new AttributeListIterator(this.attributes, this.parent, this.filterNamespaces);
    }

    @Override
    public IAttributeWrapper getByName(String name) {
        for (IAttributeWrapper attribute : this) {
            if (!name.equals(attribute.getTagName())) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public IAttributeWrapper getByName(QName qName) {
        for (IAttributeWrapper attribute : this) {
            if (!qName.equals(attribute.getQName())) continue;
            return attribute;
        }
        return null;
    }

    private static final class AttributeCounter {
        private int size = 0;

        public AttributeCounter(Iterator<IAttributeWrapper> iterator) {
            while (iterator.hasNext()) {
                iterator.next();
                ++this.size;
            }
        }

        public int size() {
            return this.size;
        }
    }

    private static final class AttributeListIterator
    implements Iterator<IAttributeWrapper> {
        private int index = 0;
        private Node node;
        private NamedNodeMap attributes;
        private IElementWrapper parent;
        private boolean filterNamespaces;

        public AttributeListIterator(NamedNodeMap attributes, IElementWrapper parent, boolean filterNamespaces) {
            this.attributes = attributes;
            this.parent = parent;
            this.filterNamespaces = filterNamespaces;
        }

        @Override
        public boolean hasNext() {
            if (this.node == null) {
                this.node = this.findNextAttribute();
            }
            return this.node != null;
        }

        @Override
        public IAttributeWrapper next() {
            IAttributeWrapper wrapper;
            if (this.node != null) {
                wrapper = W3CFactory.wrapAttribute(this.node, this.parent);
                this.node = null;
            } else {
                Node nextAttribute = this.findNextAttribute();
                if (nextAttribute == null) {
                    throw new NoSuchElementException();
                }
                wrapper = W3CFactory.wrapAttribute(nextAttribute, this.parent);
            }
            return wrapper;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove method is not implemented yet!!!");
        }

        private Node findNextAttribute() {
            Node node = null;
            while (this.index < this.attributes.getLength()) {
                Node item = this.attributes.item(this.index);
                ++this.index;
                if (2 != item.getNodeType() || this.filterNamespaces && item.getNodeName().startsWith("xmlns")) continue;
                node = item;
                break;
            }
            return node;
        }
    }
}

