/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.dom.w3c.impl;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.mule.tooling.core.dom.INodeWrapper;
import org.mule.tooling.core.dom.NodeType;
import org.w3c.dom.Node;

public abstract class AbstractNodeWrapperW3C
implements INodeWrapper {
    private Node node;
    private static final Map<Short, NodeType> typesMap = new HashMap<Short, NodeType>(5, 1.0f);

    static {
        typesMap.put((short)1, NodeType.ELEMENT);
        typesMap.put((short)2, NodeType.ATTRIBUTE);
        typesMap.put((short)3, NodeType.TEXT);
        typesMap.put((short)4, NodeType.CDATA);
        typesMap.put((short)8, NodeType.COMMENT);
    }

    protected AbstractNodeWrapperW3C(Node node) {
        this.node = node;
    }

    public Node getNode() {
        return this.node;
    }

    @Override
    public QName getQName() {
        Node myNode = this.getNode();
        String prefix = myNode.getPrefix();
        String localName = myNode.getLocalName();
        return new QName(myNode.getNamespaceURI(), localName != null ? localName : "", prefix != null ? prefix : "");
    }

    @Override
    public NodeType getNodeType() {
        return typesMap.get(this.getNode().getNodeType());
    }

    @Override
    public void setNodeValue(String property) {
        this.getNode().setNodeValue(property);
    }
}

