/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.dom.dom4j.impl;

import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.dom.INodeListWrapper;
import org.mule.tooling.core.dom.dom4j.impl.DOM4JFactory;

public final class NodeListWrapperDOM4J
implements INodeListWrapper<IElementWrapper> {
    private Element element;
    private List<Element> elements;

    public NodeListWrapperDOM4J(Element element, List<Element> elements) {
        this.element = element;
        this.elements = elements;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public IElementWrapper get(int index) {
        return DOM4JFactory.wrapElement(this.elements.get(index));
    }

    @Override
    public Iterator<IElementWrapper> iterator() {
        return new ElementListIterator(this.elements);
    }

    @Override
    public IElementWrapper getByName(String elementName) {
        return DOM4JFactory.wrapElement(this.element.element(elementName));
    }

    @Override
    public int indexOf(IElementWrapper elementWrapper) {
        Iterator<IElementWrapper> iterator = this.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            IElementWrapper element = iterator.next();
            if (element.equals(elementWrapper)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private static final class ElementListIterator
    implements Iterator<IElementWrapper> {
        private Iterator<Element> iterator;

        public ElementListIterator(List<Element> elements) {
            this.iterator = elements.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public IElementWrapper next() {
            return DOM4JFactory.wrapElement(this.iterator.next());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

