/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.dom.dom4j.impl;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.mule.tooling.core.dom.IAttributeListWrapper;
import org.mule.tooling.core.dom.IAttributeWrapper;
import org.mule.tooling.core.dom.IDocumentWrapper;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.dom.INodeListWrapper;
import org.mule.tooling.core.dom.INodeWrapper;
import org.mule.tooling.core.dom.dom4j.impl.AbstractNodeWrapperDOM4J;
import org.mule.tooling.core.dom.dom4j.impl.DOM4JFactory;
import org.mule.tooling.core.dom.location.IElementLocation;
import org.mule.tooling.core.dom.location.impl.DefaultLineLocation;
import org.mule.tooling.core.sax.ElementWithLocation;

public final class ElementWrapperDOM4J
extends AbstractNodeWrapperDOM4J
implements IElementWrapper {
    private Element element;

    protected ElementWrapperDOM4J(Element element) {
        super((Node)element);
        this.element = element;
    }

    @Override
    public String getName() {
        return this.element.getName();
    }

    @Override
    public void setQName(QName qname) {
        throw new UnsupportedOperationException();
    }

    @Override
    public QName getQName() {
        return new QName(this.element.getNamespaceURI(), this.element.getName(), this.element.getNamespacePrefix());
    }

    @Override
    public String getTagName() {
        return this.getTagName(this.element);
    }

    @Override
    public String getNamespacePrefix() {
        return this.getQName().getPrefix();
    }

    @Override
    public String getNamespaceURI() {
        return this.getQName().getNamespaceURI();
    }

    @Override
    public IDocumentWrapper getDocument() {
        return DOM4JFactory.wrapDocument(this.element.getDocument());
    }

    @Override
    public String asXML() {
        return this.element.asXML();
    }

    @Override
    public IElementWrapper createCopy() {
        return DOM4JFactory.wrapElement(this.element.createCopy());
    }

    @Override
    public String getText() {
        return this.element.getText();
    }

    @Override
    public IElementLocation getLocation() {
        ElementWithLocation elementWithLocation = (ElementWithLocation)this.element;
        return new DefaultLineLocation(elementWithLocation.getLineNumber(), elementWithLocation.getEndLineNumber(), elementWithLocation.getColumnNumber(), elementWithLocation.getEndColumnNumber());
    }

    @Override
    public IAttributeWrapper getAttribute(String name) {
        return this.getAttributes().getByName(name);
    }

    @Override
    public IAttributeWrapper getAttribute(QName qName) {
        return this.getAttributes().getByName(qName);
    }

    @Override
    public String getAttributeValue(String name) {
        IAttributeWrapper attribute = this.getAttributes().getByName(name);
        return attribute != null ? attribute.getText() : null;
    }

    @Override
    public void add(INodeWrapper childNode) {
        if (!(childNode instanceof AbstractNodeWrapperDOM4J)) {
            throw new IllegalArgumentException("Not an instance of AbstractNodeWrapperDOM4J: " + String.valueOf(childNode));
        }
        AbstractNodeWrapperDOM4J dom4jWrapper = (AbstractNodeWrapperDOM4J)childNode;
        this.element.add(dom4jWrapper.getNode());
    }

    @Override
    public void add(int index, INodeWrapper childNode) {
        if (childNode instanceof AbstractNodeWrapperDOM4J) {
            AbstractNodeWrapperDOM4J dom4jWrapper = (AbstractNodeWrapperDOM4J)childNode;
            List content = this.element.content();
            int size = this.element.elements().size();
            if (index > size || index < 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
            }
            if (size > index) {
                Object node = this.element.elements().get(index);
                int realIndex = content.indexOf(node);
                if (index > 0) {
                    content.add(realIndex, dom4jWrapper.getNode());
                }
            } else {
                this.add(childNode);
            }
        } else {
            throw new IllegalArgumentException("Not an instance of AbstractNodeWrapperDOM4J: " + String.valueOf(childNode));
        }
    }

    @Override
    public void addBefore(INodeWrapper childNode, INodeWrapper beforeNode) {
        if (childNode instanceof AbstractNodeWrapperDOM4J && beforeNode instanceof AbstractNodeWrapperDOM4J) {
            AbstractNodeWrapperDOM4J childDom4jWrapper = (AbstractNodeWrapperDOM4J)childNode;
            AbstractNodeWrapperDOM4J beforeDom4jWrapper = (AbstractNodeWrapperDOM4J)beforeNode;
            List content = this.element.content();
            int index = content.indexOf(beforeDom4jWrapper.getNode());
            if (index < 0) {
                this.element.add(childDom4jWrapper.getNode());
            } else {
                content.add(index, childDom4jWrapper.getNode());
            }
        } else {
            throw new IllegalArgumentException("Not an instance of AbstractNodeWrapperDOM4J: " + String.valueOf(!(childNode instanceof AbstractNodeWrapperDOM4J) ? childNode : beforeNode));
        }
    }

    @Override
    public void addAfter(INodeWrapper childNode, INodeWrapper afterNode) {
        if (childNode instanceof AbstractNodeWrapperDOM4J && afterNode instanceof AbstractNodeWrapperDOM4J) {
            INodeWrapper nextAfterDom4jWrapper = this.findAfterNode((AbstractNodeWrapperDOM4J)afterNode);
            if (nextAfterDom4jWrapper == null) {
                this.add(childNode);
            } else {
                this.addBefore(childNode, nextAfterDom4jWrapper);
            }
        } else {
            throw new IllegalArgumentException("Not an instance of AbstractNodeWrapperDOM4J: " + String.valueOf(!(childNode instanceof AbstractNodeWrapperDOM4J) ? childNode : afterNode));
        }
    }

    @Override
    public void removeChild(INodeWrapper oldChild) {
        if (!(oldChild instanceof AbstractNodeWrapperDOM4J)) {
            throw new IllegalArgumentException("Not an instance of AbstractNodeWrapperDOM4J: " + String.valueOf(oldChild));
        }
        AbstractNodeWrapperDOM4J oldChildDom4jWrapper = (AbstractNodeWrapperDOM4J)oldChild;
        this.element.remove(oldChildDom4jWrapper.getNode());
    }

    @Override
    public void removeAttribute(String name) {
        Attribute attribute = this.element.attribute(name);
        if (attribute != null) {
            this.element.remove(attribute);
        }
    }

    @Override
    public IElementWrapper addAttribute(String name, String value) {
        return DOM4JFactory.wrapElement(this.element.addAttribute(name, value));
    }

    @Override
    public IElementWrapper addAttribute(QName name, String value) {
        return DOM4JFactory.wrapElement(this.element.addAttribute(this.toDom4j(name), value));
    }

    @Override
    public IElementWrapper getElement(String name) {
        Element childElement = this.element.element(name);
        return DOM4JFactory.wrapElement(childElement);
    }

    @Override
    public IElementWrapper getElement(QName qName) {
        Element childElement = this.element.element(new org.dom4j.QName(qName.getLocalPart(), Namespace.get((String)qName.getPrefix(), (String)qName.getNamespaceURI())));
        return DOM4JFactory.wrapElement(childElement);
    }

    @Override
    public IElementWrapper getParent() {
        return DOM4JFactory.wrapElement(this.element.getParent());
    }

    @Override
    public INodeListWrapper<INodeWrapper> getChildNodes() {
        return DOM4JFactory.wrapChildNodes(this.element, this.element.content());
    }

    @Override
    public INodeListWrapper<IElementWrapper> getChildElements() {
        return DOM4JFactory.wrapChildren(this.element, this.element.elements());
    }

    @Override
    public INodeListWrapper<IElementWrapper> getChildElements(QName qName) {
        return DOM4JFactory.wrapChildren(this.element, this.element.elements(new org.dom4j.QName(qName.getLocalPart(), Namespace.get((String)qName.getPrefix(), (String)qName.getNamespaceURI()))));
    }

    @Override
    public IAttributeListWrapper getAttributes() {
        return DOM4JFactory.wrapAttributes(this.element, this.element.attributes());
    }

    @Override
    public IAttributeListWrapper getNamespaceAttributes() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.element.toString();
    }

    @Override
    public String getScriptText() {
        StringBuilder textBuilder = new StringBuilder();
        List content = this.element.content();
        for (Object object : content) {
            if (object instanceof CDATA) {
                CDATA cdata = (CDATA)object;
                textBuilder.append(cdata.getText());
                continue;
            }
            if (object instanceof Node) {
                Node node = (Node)object;
                if (node.getNodeType() != 3 || StringUtils.isBlank((String)node.getText())) continue;
                textBuilder.append(node.getText());
                continue;
            }
            throw new IllegalArgumentException("Invalid node type");
        }
        return textBuilder.toString();
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public boolean equals(Object objectToTest) {
        if (objectToTest == this) {
            return true;
        }
        if (objectToTest == null || !(objectToTest instanceof ElementWrapperDOM4J)) {
            return false;
        }
        ElementWrapperDOM4J elementWrapperDOM4J = (ElementWrapperDOM4J)objectToTest;
        return this.element.equals(elementWrapperDOM4J.element);
    }

    public String getTagName(Element element) {
        Object name = null;
        name = !StringUtils.isEmpty((String)element.getNamespacePrefix()) ? element.getNamespacePrefix() + ":" + element.getName() : element.getName();
        return name;
    }

    @Override
    public boolean hasContent() {
        return this.element.hasContent();
    }

    private org.dom4j.QName toDom4j(QName qName) {
        return qName != null ? new org.dom4j.QName(qName.getLocalPart(), Namespace.get((String)qName.getPrefix(), (String)qName.getNamespaceURI())) : null;
    }

    private INodeWrapper findAfterNode(AbstractNodeWrapperDOM4J afterNode) {
        List content = this.element.content();
        int index = content.indexOf(afterNode.getNode());
        ++index;
        while (index < content.size()) {
            Object object = content.get(index);
            if (object instanceof Element) break;
            ++index;
        }
        return index < content.size() ? DOM4JFactory.wrapElement((Element)content.get(index)) : null;
    }

    @Override
    public boolean isEmpty() {
        return !this.hasContent();
    }
}

