/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.dom.dom4j.impl;

import javax.xml.namespace.QName;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Namespace;
import org.mule.tooling.core.dom.IDocumentWrapper;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.dom.INodeWrapper;
import org.mule.tooling.core.dom.dom4j.impl.AbstractNodeWrapperDOM4J;
import org.mule.tooling.core.dom.dom4j.impl.DOM4JFactory;
import org.mule.tooling.core.sax.SAXUtils;

public final class DocumentWrapperDOM4J
implements IDocumentWrapper {
    private Document document;

    protected DocumentWrapperDOM4J(Document document) {
        this.document = document;
    }

    @Override
    public String getDefaultNamespaceURI() {
        Namespace defaultNamespace = this.document.getRootElement().getNamespaceForPrefix("");
        return defaultNamespace != null ? defaultNamespace.getURI() : null;
    }

    @Override
    public IElementWrapper getRootElement() {
        return this.document.getRootElement() != null ? DOM4JFactory.wrapElement(this.document.getRootElement()) : null;
    }

    @Override
    public void add(INodeWrapper element) {
        if (!(element instanceof AbstractNodeWrapperDOM4J)) {
            throw new IllegalArgumentException("Not an instance of AbstractNodeWrapperDOM4J: " + String.valueOf(element));
        }
        AbstractNodeWrapperDOM4J dom4jWrapper = (AbstractNodeWrapperDOM4J)element;
        this.document.add(dom4jWrapper.getNode());
    }

    @Override
    public INodeWrapper createText(String text) {
        return DOM4JFactory.wrapElement(DocumentHelper.createText((String)text));
    }

    @Override
    public INodeWrapper createCDATA(String data) {
        return DOM4JFactory.wrapElement(DocumentHelper.createCDATA((String)data));
    }

    @Override
    public IElementWrapper createElement(QName qName) {
        Namespace defaultNamespace;
        org.dom4j.QName dom4jQname;
        org.dom4j.QName elementQname = dom4jQname = this.toDom4j(qName);
        Namespace namespace = defaultNamespace = this.document.getRootElement() != null ? this.document.getRootElement().getNamespaceForPrefix("") : null;
        if (dom4jQname.getNamespace() == null || defaultNamespace != null && defaultNamespace.getURI().equals(dom4jQname.getNamespace().getURI())) {
            elementQname = this.toDom4j(new QName(qName.getNamespaceURI(), qName.getLocalPart()));
        }
        return DOM4JFactory.wrapElement(SAXUtils.createElement(elementQname));
    }

    private org.dom4j.QName toDom4j(QName qName) {
        return qName != null ? new org.dom4j.QName(qName.getLocalPart(), Namespace.get((String)qName.getPrefix(), (String)qName.getNamespaceURI())) : null;
    }

    @Override
    public INodeWrapper createComment(String comment) {
        return DOM4JFactory.wrapElement(DocumentHelper.createComment((String)comment));
    }
}

