/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.dom.dom4j.impl;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.mule.tooling.core.dom.IAttributeListWrapper;
import org.mule.tooling.core.dom.IAttributeWrapper;
import org.mule.tooling.core.dom.dom4j.impl.DOM4JFactory;

public final class AttributeListWrapperDOM4J
implements IAttributeListWrapper {
    private Element element;
    private List<Attribute> attributes;

    protected AttributeListWrapperDOM4J(Element element, List<Attribute> attributes) {
        this.element = element;
        this.attributes = attributes;
    }

    @Override
    public int size() {
        return this.attributes.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<IAttributeWrapper> iterator() {
        return new AttributeListIterator(this.attributes);
    }

    @Override
    public IAttributeWrapper getByName(String name) {
        return DOM4JFactory.wrapAttribute(this.element.attribute(name));
    }

    @Override
    public IAttributeWrapper getByName(QName qName) {
        Attribute attribute = this.element.attribute(new org.dom4j.QName(qName.getLocalPart(), Namespace.get((String)qName.getPrefix(), (String)qName.getNamespaceURI())));
        return DOM4JFactory.wrapAttribute(attribute);
    }

    private static final class AttributeListIterator
    implements Iterator<IAttributeWrapper> {
        private Iterator<Attribute> iterator;

        public AttributeListIterator(List<Attribute> attributes) {
            this.iterator = attributes.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public IAttributeWrapper next() {
            return DOM4JFactory.wrapAttribute(this.iterator.next());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

