/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.dom;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.UUID;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.mule.tooling.core.dom.IAttributeWrapper;
import org.mule.tooling.core.dom.IDocumentWrapper;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.dom.dom4j.impl.DOM4JFactory;
import org.mule.tooling.core.dom.w3c.impl.W3CFactory;
import org.mule.tooling.core.runtime.server.ISchemaLocationLookup;

public class DOMFactory {
    public static IDocumentWrapper newDOM4JDocumentWrapper() {
        return DOMFactory.from(DocumentHelper.createDocument());
    }

    public static IDocumentWrapper from(Document document) {
        return DOM4JFactory.wrapDocument(document);
    }

    public static IDocumentWrapper newW3CDocumentWrapper(ISchemaLocationLookup schemaLocationLookup) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream("".getBytes());
            IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().getModelForRead(UUID.randomUUID().toString().replaceAll("-", "") + ".xml", (InputStream)is, null);
            IDOMDocument document = model.getDocument();
            return DOMFactory.from((org.w3c.dom.Document)document, schemaLocationLookup);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static IDocumentWrapper from(org.w3c.dom.Document document, ISchemaLocationLookup schemaLocationLookup) {
        return W3CFactory.wrapDocument(document, schemaLocationLookup);
    }

    public static IDOMModel getModel(String id, String content) throws UnsupportedEncodingException, IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes());
        return (IDOMModel)StructuredModelManager.getModelManager().getModelForRead(id, (InputStream)is, null);
    }

    public static IElementWrapper from(Element element) {
        return DOM4JFactory.wrapElement(element);
    }

    public static IAttributeWrapper from(Attribute attribute) {
        return DOM4JFactory.wrapAttribute(attribute);
    }
}

