/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.deployer;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.core.resources.ResourcesPlugin;
import org.mule.tooling.core.runtime.server.IServerDefinition;

public final class MuleLocator {
    private static final String CMD_EXTENSION = "cmd";
    private static final String BAT_EXTENSION = "bat";
    private IServerDefinition serverDefinition;

    public static MuleLocator create(IServerDefinition serverDefinition) {
        return new MuleLocator(serverDefinition);
    }

    private MuleLocator(IServerDefinition serverDefinition) {
        this.serverDefinition = serverDefinition;
    }

    public String getInstallationDirectoryRootPath() {
        return this.serverDefinition.getPluginBaseDirectory().append("mule").toString();
    }

    public String getWorkingDirectoryRootPath() {
        File root = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
        File muleFolder = new File(root, ".mule");
        if (!muleFolder.exists()) {
            muleFolder.mkdir();
        }
        return muleFolder.getAbsolutePath();
    }

    public String getConfPath() {
        return this.getInstallationDirectoryRootPath() + File.separator + "conf";
    }

    public String getBinPath() {
        return this.getInstallationDirectoryRootPath() + File.separator + "bin";
    }

    public String getLibBootExecPath() {
        return this.getInstallationDirectoryRootPath() + File.separator + "lib" + File.separator + "boot" + File.separator + "exec";
    }

    public String getScriptPath() {
        return this.getBinPath() + File.separator + this.getScriptName();
    }

    public String getWrapperConfPath() {
        return this.getInstallationDirectoryRootPath() + File.separator + "conf" + File.separator + this.getWrapperConfigName();
    }

    public String getWrapperConfBasePath() {
        return this.getWrapperConfPath() + ".template";
    }

    public boolean isScriptFilename(String fileName) {
        String extension = FilenameUtils.getExtension((String)fileName);
        String string = extension = extension != null ? extension.toLowerCase() : "";
        return extension.endsWith(CMD_EXTENSION) || extension.endsWith(BAT_EXTENSION) || StringUtils.isBlank((String)extension);
    }

    private String getScriptName() {
        String script = "";
        if (SystemUtils.IS_OS_WINDOWS) {
            script = "mule.bat";
        } else if (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_MAC_OSX) {
            script = "mule";
        } else {
            throw new IllegalArgumentException("Unknown operating system " + SystemUtils.OS_NAME);
        }
        return script;
    }

    private String getWrapperConfigName() {
        return "wrapper.conf";
    }

    public String getAgentConfPath() {
        return this.getConfPath() + File.separator + "mule-agent.yml";
    }
}

