/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.deployer;

import com.google.common.base.Predicate;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.classloader.ProjectClasspathUtils;
import org.mule.tooling.core.deployer.MuleArtifactJsonModel;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.utils.ProjectStructureContributionManager;
import org.mule.tooling.core.utils.StudioFileUtils;
import org.mule.tooling.utils.collection.ListView;

public class MuleApplicationDeployment {
    private static final String CLASSES_DIRECTORY_NAME = "classes";
    private static final String CLASSLOADER_MODEL_FILENAME = "classloader-model.json";
    private static final String MULE_ARTIFACT_DIRECTORY_NAME = "mule-artifact";
    private static final String MAVEN_DIRECTORY_NAME = "maven";
    private static final String REPOSITORY_DIRECTORY_NAME = "repository";
    private static final String META_INF_DIRECTORY_NAME = "META-INF";
    private static final String TARGET_DIRECTORY_NAME = "target";
    private static final int MAX_ENTRIES = 10;
    private static Map<IProject, Job> processClassesJobs = new LinkedHashMap<IProject, Job>(10){
        private static final long serialVersionUID = -1025265003381200495L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<IProject, Job> eldest) {
            return super.size() > 10;
        }
    };
    private File projectFolder;
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public MuleApplicationDeployment(File deploymentTargetFolder) {
        this.projectFolder = deploymentTargetFolder;
    }

    public void initialize(boolean deleteExisting) throws CoreException {
        if (deleteExisting) {
            FileUtils.deleteQuietly((File)this.projectFolder);
        }
        this.createIfNotExist(this.projectFolder);
    }

    public static void storeProcessClassesJob(IProject muleProject, Job job) {
        processClassesJobs.put(muleProject, job);
    }

    public static void executePackageJob(IMuleProject muleProject) {
        Job compileJob = processClassesJobs.get(muleProject.getProject());
        if (compileJob != null) {
            compileJob.schedule();
            try {
                compileJob.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public List<File> compileAndCopyConfigFilesAndDirectories(IMuleProject muleProject) throws CoreException {
        MuleApplicationDeployment.executePackageJob(muleProject);
        IFolder targetFolder = muleProject.getFolder(TARGET_DIRECTORY_NAME);
        IFolder metaInfFolder = targetFolder.getFolder(META_INF_DIRECTORY_NAME);
        File pom = new File(metaInfFolder.getFolder(MAVEN_DIRECTORY_NAME).getLocationURI());
        File muleArtifactJson = new File(metaInfFolder.getFolder(MULE_ARTIFACT_DIRECTORY_NAME).getFile("mule-artifact.json").getLocationURI());
        File classloader = new File(metaInfFolder.getFolder(MULE_ARTIFACT_DIRECTORY_NAME).getFile(CLASSLOADER_MODEL_FILENAME).getLocationURI());
        File dependencies = new File(targetFolder.getFolder(REPOSITORY_DIRECTORY_NAME).getLocationURI());
        try {
            StudioFileUtils.copyFiles(pom, new File(this.projectFolder.getAbsolutePath(), File.separator + META_INF_DIRECTORY_NAME + File.separator + MAVEN_DIRECTORY_NAME));
            String artifactDirectoryBasePath = File.separator + META_INF_DIRECTORY_NAME + File.separator + MULE_ARTIFACT_DIRECTORY_NAME + File.separator;
            StudioFileUtils.copyFiles(classloader, new File(this.projectFolder.getAbsolutePath(), artifactDirectoryBasePath + CLASSLOADER_MODEL_FILENAME));
            StudioFileUtils.copyFiles(muleArtifactJson, new File(this.projectFolder.getAbsolutePath(), artifactDirectoryBasePath + "mule-artifact.json"));
            StudioFileUtils.copyFiles(dependencies, new File(this.projectFolder.getAbsolutePath(), File.separator + REPOSITORY_DIRECTORY_NAME));
        }
        catch (IOException e) {
            MuleCorePlugin.logError("There was a problem collecting files to be copied from: " + pom.getAbsolutePath() + " - " + classloader.getParent() + " - " + dependencies.getAbsolutePath(), e);
            return Collections.emptyList();
        }
        IFolder muleAppsFolder = muleProject.getMuleAppsFolder();
        IFolder muleResourcesFolder = muleProject.getMuleResourcesFolder();
        List contributedFolders = ProjectStructureContributionManager.getDefault().getRuntimeContributions().stream().map(contrib -> contrib.getFolderPath()).map(path -> muleProject.getFolder((String)path)).collect(Collectors.toList());
        List runtimeFolders = ListView.of(Arrays.asList(muleAppsFolder, muleResourcesFolder), contributedFolders);
        Predicate filter = MuleProjectKind.APPLICATION.classifies(muleProject) ? r -> !MuleProjectKind.APPLICATION.adapt(muleProject).isTestResource((IResource)r) : r -> true;
        LinkedList resourcesToCopy = new LinkedList();
        runtimeFolders.forEach(folder -> this.acceptVisitor((IFolder)folder, resource -> {
            if (filter.apply((Object)resource) && !(resource instanceof IContainer)) {
                resourcesToCopy.add(resource);
            }
            return true;
        }));
        File classesFolder = new File(muleProject.getFolder(TARGET_DIRECTORY_NAME).getFolder(CLASSES_DIRECTORY_NAME).getLocationURI());
        LinkedList<File> copiedResources = new LinkedList<File>();
        for (IResource resource : resourcesToCopy) {
            Optional<File> maybeDestFile = MuleResourceUtils.getConfigurationFileInDeploymentFolder(resource, this.projectFolder, muleProject);
            Optional<File> maybeSrcFile = MuleResourceUtils.getConfigurationFileInDeploymentFolder(resource, classesFolder, muleProject);
            if (!maybeDestFile.isPresent() || !maybeSrcFile.isPresent()) continue;
            File destFile = maybeDestFile.get();
            File srcFile = maybeSrcFile.get();
            if (!srcFile.exists()) continue;
            this.copyFile(srcFile, destFile);
            copiedResources.add(destFile);
        }
        return copiedResources;
    }

    private void copyFile(File srcFile, File destFile) throws CoreException {
        try {
            FileUtils.copyFile((File)srcFile, (File)destFile, (boolean)false);
        }
        catch (IOException e) {
            throw new CoreException(MuleCorePlugin.createStatus(4, "Unable to copy file for launch: " + String.valueOf(srcFile), e));
        }
    }

    private void acceptVisitor(IFolder folder, IResourceVisitor visitor) {
        try {
            folder.accept(visitor);
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("There was a problem collecting files to be copied from: " + String.valueOf(folder), e);
        }
    }

    public static boolean updateDeploymentDescriptor(IMuleProject project) {
        boolean retVal = true;
        IFile deployProps = project.getFile("mule-artifact.json");
        try {
            if (!deployProps.exists()) {
                retVal = MuleApplicationDeployment.createNewDeploymentDescriptor(project, deployProps);
            }
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("Error trying to update mule-artifact.json", e);
            retVal = false;
        }
        return retVal;
    }

    private static boolean createNewDeploymentDescriptor(IMuleProject project, IFile deployProps) throws CoreException {
        boolean retVal;
        block22: {
            retVal = true;
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                    if (MuleProjectKind.APPLICATION.classifies(project) || MuleProjectKind.DOMAIN.classifies(project)) {
                        MuleApplicationDeployment.createMuleArtifactJson(project, out);
                    } else {
                        MuleCorePlugin.logWarning("Unsupported classifier:" + String.valueOf(project.getKind()));
                        retVal = false;
                    }
                    if (!retVal) break block22;
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (ByteArrayInputStream input = new ByteArrayInputStream(out.toByteArray());){
                        deployProps.create((InputStream)input, true, null);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                MuleCorePlugin.logError("Unable to create properties file for deployment descriptor.", e);
                retVal = false;
            }
        }
        return retVal;
    }

    private static void createMuleArtifactJson(IMuleProject project, ByteArrayOutputStream out) throws CoreException, IOException {
        String versionWithPatchVersionZero = project.getServerDefinition().getVersionWithPatchVersionZero();
        String[] specificationJavaVersion = new String[]{ProjectClasspathUtils.getShortJavaVersion(project.getJavaProject())};
        String muleArtifactJsonModel = gson.toJson((Object)new MuleArtifactJsonModel(versionWithPatchVersionZero, specificationJavaVersion));
        out.write(muleArtifactJsonModel.getBytes());
    }

    public static void updateMuleArtifactJson(IMuleProject project, IFile deployProps) throws CoreException, IOException {
        if (!deployProps.isReadOnly()) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            MuleApplicationDeployment.createMuleArtifactJson(project, out);
            ByteArrayInputStream source = new ByteArrayInputStream(out.toByteArray());
            if (deployProps.exists()) {
                deployProps.setContents((InputStream)source, 2, (IProgressMonitor)new NullProgressMonitor());
            } else {
                deployProps.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    private void createIfNotExist(File directory) {
        if (!directory.exists()) {
            directory.mkdirs();
        }
    }
}

