/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.deployer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.deployer.MuleLocator;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.StudioFileUtils;

public class DeploymentHelper {
    public static final String MULE_LAUNCH_DIRECTORY = ".mule";
    public static final String MULE_DOMAINS_DIRECTORY = "domains";
    public static final String MULE_CONF_DIRECTORY = "conf";
    private static final String DEFAULT_LOG4J_PROPERTIES = "log4j.properties";
    private static final String DEFAULT_LOG4J2_PROPERTIES = "log4j2.xml";
    private IMuleProject muleProject;

    public static File getMuleDefaultDomainDirectory(IServerDefinition serverDefinition) {
        return DeploymentHelper.getMuleDomainDirectory("default", serverDefinition);
    }

    public static File getMuleDomainDirectory(String domainName, IServerDefinition serverDefinition) {
        return new File(DeploymentHelper.getMuleLaunchFolder(serverDefinition), MULE_DOMAINS_DIRECTORY + File.separator + domainName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean prepareMuleWorkspaceDirectory(IServerDefinition serverDefinition) throws IOException {
        File muleAppsFolder = DeploymentHelper.getMuleAppsFolder(serverDefinition);
        File muleDomainsFolder = DeploymentHelper.getMuleDomainsFolder(serverDefinition);
        if (!(DeploymentHelper.clearAndPrepareFolder(muleAppsFolder) && DeploymentHelper.clearAndPrepareFolder(muleDomainsFolder) && DeploymentHelper.clearAndPrepareFolder(DeploymentHelper.getStagingFolder(muleAppsFolder)) && DeploymentHelper.clearAndPrepareFolder(DeploymentHelper.getStagingFolder(muleDomainsFolder)))) {
            return false;
        }
        File confFolder = DeploymentHelper.getMuleConfFolder(serverDefinition);
        DeploymentHelper.createIfNotExist(confFolder);
        File newDomainsFolder = DeploymentHelper.getMuleDefaultDomainDirectory(serverDefinition);
        DeploymentHelper.createIfNotExist(newDomainsFolder);
        ClassLoader classLoader = CoreUtils.class.getClassLoader();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try {
                InputStream log4jDefaultFile = classLoader.getResourceAsStream(DEFAULT_LOG4J_PROPERTIES);
                try {
                    try (InputStream log4j2DefaultFile = classLoader.getResourceAsStream(DEFAULT_LOG4J2_PROPERTIES);){
                        Files.copy(log4jDefaultFile, new File(confFolder, DEFAULT_LOG4J_PROPERTIES).toPath(), StandardCopyOption.REPLACE_EXISTING);
                        Files.copy(log4j2DefaultFile, new File(confFolder, DEFAULT_LOG4J2_PROPERTIES).toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    if (log4jDefaultFile == null) return true;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (log4jDefaultFile == null) throw throwable;
                    log4jDefaultFile.close();
                    throw throwable;
                }
                log4jDefaultFile.close();
                return true;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            MuleCorePlugin.logError("Error creating runtimes log4j properties files.", e);
            return false;
        }
    }

    private static boolean clearAndPrepareFolder(File folder) {
        if (folder.exists()) {
            File[] children = folder.listFiles();
            if (children == null) {
                MuleCorePlugin.logError("Error trying to clean the folder " + folder.getName() + " in the embedded mule instance", new IllegalArgumentException("The folder " + folder.getName() + " does not exist."));
                return false;
            }
            boolean success = true;
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                success &= FileUtils.deleteQuietly((File)file);
                ++n2;
            }
            return success;
        }
        folder.mkdirs();
        return true;
    }

    public static File getStagingFolder(File artifactsFolder) {
        return new File(artifactsFolder.getParentFile(), artifactsFolder.getName() + "-staging");
    }

    public static File getMuleAppsFolder(IServerDefinition serverDefinition) {
        return new File(DeploymentHelper.getMuleLaunchFolder(serverDefinition), "apps");
    }

    public static File getMuleDomainsFolder(IServerDefinition serverDefinition) {
        return new File(DeploymentHelper.getMuleLaunchFolder(serverDefinition), MULE_DOMAINS_DIRECTORY);
    }

    public static File getMuleConfFolder(IServerDefinition serverDefinition) {
        return new File(DeploymentHelper.getMuleLaunchFolder(serverDefinition), MULE_CONF_DIRECTORY);
    }

    public static File getDefaultLog4j2PropertiesFile(IServerDefinition serverDefinition) {
        return new File(DeploymentHelper.getMuleConfFolder(serverDefinition), DEFAULT_LOG4J2_PROPERTIES);
    }

    public static File getMuleLaunchFolder(IServerDefinition serverDefinition) {
        if ("this //TODO ^".isEmpty()) {
            return StudioFileUtils.getWorkspaceTempLocation().getParentFile();
        }
        return new File(MuleLocator.create(serverDefinition).getInstallationDirectoryRootPath());
    }

    public static File getApplicationsDataFolder(IServerDefinition serverDefinition) {
        File muleLaunchFolder = DeploymentHelper.getMuleLaunchFolder(serverDefinition);
        return new File(muleLaunchFolder, MULE_LAUNCH_DIRECTORY);
    }

    public DeploymentHelper(IMuleProject muleProject) {
        this.muleProject = muleProject;
    }

    public File getDeploymentClassesFolder() {
        File projectFolder = this.getProjectDeploymentFolder();
        return new File(projectFolder, "classes");
    }

    public File getProjectDeploymentFolder() {
        String projectName = this.muleProject.getName().replace(' ', '_');
        return new File(DeploymentHelper.getMuleAppsFolder(this.muleProject.getServerDefinition()), projectName);
    }

    public File getProjectRootFile() {
        return this.muleProject.getJavaProject().getResource().getLocation().toFile();
    }

    public IPath getOutputPath() throws CoreException {
        return this.muleProject.getJavaProject().getOutputLocation();
    }

    public File getTargetFolder() {
        File projectRootFolder = this.getProjectRootFile();
        return new File(projectRootFolder, "target");
    }

    public File getApplicationDataFolder() {
        File applicationsDataFolder = DeploymentHelper.getApplicationsDataFolder(this.muleProject.getServerDefinition());
        String projectName = this.muleProject.getProject().getName();
        return new File(applicationsDataFolder, projectName);
    }

    private static void createIfNotExist(File directory) {
        if (!directory.exists()) {
            directory.mkdirs();
        }
    }
}

