/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.deployer;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.tooling.core.deployer.PackagingRequest;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.ExternalContributionMuleModule;

public class DefaultPackagingRequest
implements PackagingRequest {
    private final IMuleProject project;
    private boolean attachSources;
    private String outputPath;
    private Optional<File> outputFile = Optional.empty();
    private boolean includeLinkedProjects;
    private boolean lightweight;
    private boolean onlySources;
    private boolean useLocalRepo;
    private final Map<String, Object> options;
    private boolean checkMavenVersion = true;

    public static Builder builder(IMuleProject muleProject) {
        return new Builder(muleProject);
    }

    public static final PackagingRequest create(IMuleProject muleProject) {
        return DefaultPackagingRequest.create(muleProject, true);
    }

    public static final PackagingRequest create(IMuleProject muleProject, boolean includeLinkedProjects) {
        if (muleProject == null) {
            throw new IllegalArgumentException("muleProject cannot be null");
        }
        return new DefaultPackagingRequest(muleProject, includeLinkedProjects);
    }

    public DefaultPackagingRequest(IMuleProject project, boolean includeLinkedProjects) {
        this(project, Optional.empty(), false, includeLinkedProjects, false, Collections.emptySet(), false);
    }

    public DefaultPackagingRequest(IMuleProject project, Optional<File> outputFileName, boolean attachSources, boolean includeLinkedProjects, boolean onlySources, Set<ExternalContributionMuleModule> filteredModules, boolean useLocalRepo) {
        this.project = project;
        this.outputFile = outputFileName;
        this.attachSources = attachSources;
        this.includeLinkedProjects = includeLinkedProjects;
        this.options = new HashMap<String, Object>();
        this.onlySources = onlySources;
        this.useLocalRepo = useLocalRepo;
    }

    @Override
    public IMuleProject getProject() {
        return this.project;
    }

    @Override
    public boolean isLightweight() {
        return this.lightweight;
    }

    @Override
    public boolean attachSources() {
        return this.attachSources;
    }

    @Override
    public boolean includeLinkedProjects() {
        return this.includeLinkedProjects;
    }

    @Override
    public boolean checkMavenVersion() {
        return this.checkMavenVersion;
    }

    @Override
    public Optional<File> getOutputFile() {
        return this.outputFile;
    }

    @Override
    public Optional<Object> getOption(String key) {
        return Optional.ofNullable(this.options.get(key));
    }

    @Override
    public boolean onlySources() {
        return this.onlySources;
    }

    @Override
    public boolean useLocalRepo() {
        return this.useLocalRepo;
    }

    public String toString() {
        return "DefaultPackagingRequest [project=" + String.valueOf(this.project) + ", includeLinkedProjects=" + this.includeLinkedProjects + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.attachSources ? 1231 : 1237);
        result = 31 * result + (this.includeLinkedProjects ? 1231 : 1237);
        result = 31 * result + (this.checkMavenVersion ? 1231 : 1237);
        result = 31 * result + (this.options == null ? 0 : this.options.hashCode());
        result = 31 * result + (this.outputFile == null ? 0 : this.outputFile.hashCode());
        result = 31 * result + (this.outputPath == null ? 0 : this.outputPath.hashCode());
        result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultPackagingRequest other = (DefaultPackagingRequest)obj;
        if (this.attachSources != other.attachSources) {
            return false;
        }
        if (this.includeLinkedProjects != other.includeLinkedProjects) {
            return false;
        }
        if (this.checkMavenVersion != other.checkMavenVersion) {
            return false;
        }
        if (this.options == null ? other.options != null : !this.options.equals(other.options)) {
            return false;
        }
        if (this.outputFile == null ? other.outputFile != null : !this.outputFile.equals(other.outputFile)) {
            return false;
        }
        if (this.outputPath == null ? other.outputPath != null : !this.outputPath.equals(other.outputPath)) {
            return false;
        }
        return !(this.project == null ? other.project != null : !this.project.equals(other.project));
    }

    public static class Builder {
        private final DefaultPackagingRequest request;

        public Builder(IMuleProject muleProject) {
            this.request = new DefaultPackagingRequest(muleProject, false);
        }

        public Builder asLightWeight() {
            this.request.lightweight = true;
            return this;
        }

        public Builder attachSources() {
            this.request.attachSources = true;
            return this;
        }

        public Builder useLocalRepo() {
            this.request.useLocalRepo = true;
            return this;
        }

        public Builder useLocalRepo(boolean useLocalRepo) {
            this.request.useLocalRepo = useLocalRepo;
            return this;
        }

        public Builder attachSources(boolean attachSources) {
            this.request.attachSources = attachSources;
            return this;
        }

        public Builder outputFile(File outputFile) {
            this.request.outputFile = Optional.of(outputFile);
            return this;
        }

        public Builder includeLinkedProjects(boolean includeLinkedProjects) {
            this.request.includeLinkedProjects = includeLinkedProjects;
            return this;
        }

        public Builder checkMavenVersion(boolean checkMavenVersion) {
            this.request.checkMavenVersion = checkMavenVersion;
            return this;
        }

        public Builder includeLinkedProjects() {
            this.request.includeLinkedProjects = true;
            return this;
        }

        public Builder withOption(String key, Object value) {
            this.request.options.put(key, value);
            return this;
        }

        public Builder withOnlySources(boolean onlySources) {
            this.request.onlySources = onlySources;
            return this;
        }

        public DefaultPackagingRequest build() {
            return this.request;
        }
    }
}

