/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.dependencymanagement;

import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.core.dependencymanagement.AnalyticsTrackingManagerDecorator;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.requirement.ValidationResult;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.module.Requirement;
import org.mule.tooling.utils.extensionpoint.ExtensionAttribute;
import org.mule.tooling.utils.extensionpoint.ExtensionPoint;
import org.mule.tooling.utils.extensionpoint.IExtensionPointReader;

public interface RequirementDependencyManager
extends Comparable<RequirementDependencyManager> {
    public static final String OPTIONAL_DEPENDENCY_MESSAGE = "Optional dependency";

    public String getLabel(Action var1);

    public String getActionId(Action var1);

    public boolean applies(Action var1, IMuleProject var2, Requirement var3);

    public Optional<MavenDependency> run(Action var1, Shell var2, IMuleProject var3, IMessageFlowNode var4, Requirement var5, Optional<String> var6);

    public void setPriority(int var1);

    public int getPriority();

    public static ValidationResult buildSuccessResult(IMuleProject muleProject, String filePath) {
        File file = new File(filePath);
        String data = file.exists() && filePath.startsWith(MavenCore.getM2repoPath()) ? MavenUtils.getGAV(MavenUtils.getDependencyFromPath(file)) : new File(filePath).getName();
        return new ValidationResult(0, data);
    }

    public static ValidationResult buildUnsuccessfulResult(Requirement requirement) {
        if (requirement.isRequired()) {
            return new ValidationResult(4, requirement.getEmptyLocationLabel(), requirement.getErrorMesssage());
        }
        return new ValidationResult(1, OPTIONAL_DEPENDENCY_MESSAGE);
    }

    public static enum Action {
        ADD,
        MODIFY;

    }

    @ExtensionPoint(extensionPointId="org.mule.tooling.core.requirement")
    public static class RequirementDependencyManagerExtension {
        @ExtensionAttribute(optional=true)
        private int priority = 0;
        @ExtensionAttribute
        private RequirementDependencyManager manager;

        public static List<RequirementDependencyManager> getAll() {
            return Singleton.instances;
        }

        public RequirementDependencyManager getManager() {
            this.manager.setPriority(this.priority);
            return this.manager;
        }

        public void setManager(RequirementDependencyManager manager) {
            this.manager = manager;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        private static class Singleton {
            private static final List<RequirementDependencyManager> instances = Singleton.loadManagers();

            private Singleton() {
            }

            private static List<RequirementDependencyManager> loadManagers() {
                return IExtensionPointReader.create(RequirementDependencyManagerExtension.class).readAll().stream().map(e -> new AnalyticsTrackingManagerDecorator(e.getManager())).collect(Collectors.toList());
            }
        }
    }
}

