/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.dependencymanagement;

import java.util.Optional;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.core.dependencymanagement.BaseRequirementManager;
import org.mule.tooling.core.dependencymanagement.RequirementDependencyManager;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.module.Requirement;

public class RemoveDependencyRequirementManager
extends BaseRequirementManager {
    private static final String MODIFY_ACTION_ID = "REMOVE_CONFIGURED";
    private static final String MODIFY_ACTION_LABEL = "Remove configured library";

    public RemoveDependencyRequirementManager() {
        super("", "", MODIFY_ACTION_ID, MODIFY_ACTION_LABEL);
    }

    @Override
    public boolean applies(RequirementDependencyManager.Action action, IMuleProject muleProject, Requirement requirement) {
        return RequirementDependencyManager.Action.MODIFY.equals((Object)action);
    }

    @Override
    public Optional<MavenDependency> run(RequirementDependencyManager.Action action, Shell activeShell, IMuleProject muleProject, IMessageFlowNode node, Requirement requirement, Optional<String> data) {
        return data.flatMap(d -> {
            MavenDependency dependency2 = this.getDependencyFromData((String)d);
            boolean userConfirmation = this.promptForUserConfirmation(action, activeShell, dependency2);
            Optional<Object> actionedDependency = Optional.empty();
            if (userConfirmation) {
                muleProject.getMuleProjectModel().removeMavenDependency(dependency2);
                actionedDependency = Optional.of(dependency2);
            }
            return actionedDependency;
        });
    }
}

