/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.dependencymanagement;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.classloader.ProjectClasspathUtils;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.IMuleDomainProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.runtime.ApiSpecClasspathContainer;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.ExternalMuleUserLibraryClasspathContainer;
import org.mule.tooling.core.utils.MuleUserLibraryClasspathContainer;
import org.mule.tooling.core.utils.ProjectLibsClasspathContainer;
import org.mule.tooling.model.project.MuleExtension;

public class EclipseDependencyManager {
    public static final String REMOVE_DEPENDENCY_JOB_TITLE = "Removing %s dependencies from the project classpath...";
    private final Set<String> expectedRemoveEvents = Collections.synchronizedSet(new HashSet());

    public boolean consumeExpectedRemoveEvent(IdSupplier idSupplier) {
        return this.expectedRemoveEvents.remove(idSupplier.getId());
    }

    public void addExpectedRemoveEvent(IdSupplier idSupplier) {
        this.expectedRemoveEvents.add(idSupplier.getId());
    }

    public void modifyClasspath(IJavaProject javaProject, Consumer<List<IClasspathEntry>> modifyClasspathFunction, IProgressMonitor monitor) throws JavaModelException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        subMonitor.beginTask("Adding new classpath entry to project: " + javaProject.getProject().getName(), 100);
        ISchedulingRule modifyRule = this.getClasspathModificationRule(javaProject);
        Job.getJobManager().beginRule(modifyRule, (IProgressMonitor)subMonitor);
        try {
            if (javaProject.getProject().isAccessible()) {
                ArrayList classpathEntries = Lists.newArrayList((Object[])javaProject.getRawClasspath());
                ArrayList finalClasspathEntries = Lists.newArrayList();
                modifyClasspathFunction.accept(classpathEntries);
                subMonitor.worked(50);
                HashSet addedPaths = Sets.newHashSet();
                for (IClasspathEntry entry : classpathEntries) {
                    if (addedPaths.contains(entry.getPath())) continue;
                    addedPaths.add(entry.getPath());
                    finalClasspathEntries.add(entry);
                }
                IClasspathEntry[] classEntries = new IClasspathEntry[finalClasspathEntries.size()];
                javaProject.setRawClasspath(finalClasspathEntries.toArray(classEntries), (IProgressMonitor)subMonitor.split(50));
            } else {
                MuleCorePlugin.logInfo("Project " + javaProject.getProject().getName() + " no longer accessible");
            }
        }
        finally {
            Job.getJobManager().endRule(modifyRule);
        }
    }

    protected ISchedulingRule getClasspathModificationRule(IJavaProject javaProject) {
        return ProjectClasspathUtils.getClasspathModificationRule(javaProject);
    }

    public void removeApisSpecDependencyEntry(IMuleProject muleProject, MavenDependency dependency2) throws CoreException {
        IClasspathEntry targetEntry = this.getRemoveApisSpecDependencyEntry(dependency2);
        this.removeDependencyFromClasspath(muleProject, targetEntry);
    }

    private IClasspathEntry getRemoveApisSpecDependencyEntry(MavenDependency dependency2) {
        ApiSpecClasspathContainer entry = new ApiSpecClasspathContainer(dependency2);
        IClasspathEntry varEntry = JavaCore.newContainerEntry((IPath)entry.getPath(), (boolean)false);
        this.addExpectedRemoveEvent(IdSupplier.of(dependency2));
        return varEntry;
    }

    public void removeConnectorDependencyEntry(IMuleProject muleProject, MuleExtension extension) throws CoreException {
        IClasspathEntry targetEntry = this.getRemoveConnectorDependencyEntry(extension);
        this.removeDependencyFromClasspath(muleProject, targetEntry);
    }

    private IClasspathEntry getRemoveConnectorDependencyEntry(MuleExtension extension) {
        IPath entryPath = new MuleUserLibraryClasspathContainer(extension.getName()).getPath();
        this.addExpectedRemoveEvent(IdSupplier.of(extension));
        return JavaCore.newContainerEntry((IPath)entryPath);
    }

    public void removeDependencyFromClasspath(IMuleProject muleProject, IClasspathEntry targetEntry) throws CoreException {
        IJavaProject javaProject = muleProject.getJavaProject();
        this.removeEntryFromClasspath(targetEntry, javaProject);
    }

    public void removeEntryFromClasspath(IClasspathEntry targetEntry, IJavaProject javaProject) throws JavaModelException {
        this.removeEntryFromClasspath(targetEntry, javaProject, (IProgressMonitor)new NullProgressMonitor());
    }

    public void removeEntryFromClasspath(IClasspathEntry targetEntry, IJavaProject javaProject, IProgressMonitor progressMonitor) throws JavaModelException {
        Consumer<List<IClasspathEntry>> modifyClasspathFunction = entries -> {
            ArrayList entriesToRemove = Lists.newArrayList();
            entries.stream().forEach(entry -> {
                if (ProjectClasspathUtils.entriesEqualByPath(entry, targetEntry, this.isEntryARamlFragmentOrRuleset(targetEntry) ? targetEntry.getPath().segmentCount() : 4)) {
                    entriesToRemove.add(entry);
                }
            });
            entries.removeAll(entriesToRemove);
        };
        this.modifyClasspath(javaProject, modifyClasspathFunction, progressMonitor);
    }

    public void addConnectorToClasspath(ExternalContributionMuleModule module, IJavaProject javaProject) throws CoreException {
        this.addEntryToClasspath(new ExternalMuleUserLibraryClasspathContainer(module), javaProject);
    }

    public void updateDependencies(IJavaProject javaProject) throws CoreException {
        this.addEntryToClasspath(new ProjectLibsClasspathContainer(), javaProject);
    }

    public void addAPISpecDependency(MavenDependency dependency2, IJavaProject javaProject) throws CoreException {
        this.addEntryToClasspath(new ApiSpecClasspathContainer(dependency2), javaProject);
    }

    public void addEntryToClasspath(IClasspathContainer entry, IJavaProject javaProject) throws JavaModelException, CoreException {
        this.addEntryToClasspath(entry, javaProject, (IProgressMonitor)new NullProgressMonitor());
    }

    public void addEntryToClasspath(IClasspathContainer entry, IJavaProject javaProject, IProgressMonitor progressMonitor) throws JavaModelException, CoreException {
        IClasspathEntry userLibrary = JavaCore.newContainerEntry((IPath)entry.getPath(), (boolean)false);
        this.modifyClasspath(javaProject, entries -> entries.add(0, userLibrary), progressMonitor);
        ProjectClasspathUtils.reinitializeClasspathContainer(javaProject, userLibrary.getPath());
    }

    public void addDependency(String projectName, IMuleProject muleProject) {
        this.doAddDependency(projectName, muleProject);
        CoreUtils.silentRefreshProject(muleProject, (IProgressMonitor)new NullProgressMonitor());
    }

    public void removeDependency(String projectName, IMuleProject muleProject) {
        this.doRemoveDependency(projectName, muleProject);
        CoreUtils.silentRefreshProject(muleProject, (IProgressMonitor)new NullProgressMonitor());
    }

    public void replaceDependency(String oldProjectName, String newProjectName, IMuleProject muleProject) {
        this.doRemoveDependency(oldProjectName, muleProject);
        this.doAddDependency(newProjectName, muleProject);
        CoreUtils.silentRefreshProject(muleProject, (IProgressMonitor)new NullProgressMonitor());
    }

    private void doAddDependency(String projectName, IMuleProject muleProject) {
        block4: {
            try {
                IMuleDomainProject domainProject = MuleProjectKind.DOMAIN.adapt(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName));
                if (domainProject != null) {
                    IJavaProject domainJavaProject = domainProject.getJavaProject();
                    IClasspathEntry newProjectEntry = JavaCore.newProjectEntry((IPath)domainJavaProject.getPath());
                    if (!ProjectClasspathUtils.isClasspathEntryInProject(domainJavaProject.getPath(), muleProject.getJavaProject())) {
                        this.modifyClasspath(muleProject.getJavaProject(), entries -> {
                            boolean bl = entries.add(newProjectEntry);
                        }, (IProgressMonitor)new NullProgressMonitor());
                    }
                    break block4;
                }
                throw new IllegalArgumentException("referenced project does not exist: " + projectName);
            }
            catch (CoreException e) {
                MuleCorePlugin.logError("There was a problem adding a project dependency from: " + String.valueOf(muleProject) + " to " + projectName, e);
            }
        }
    }

    private void doRemoveDependency(String projectName, IMuleProject muleProject) {
        try {
            IClasspathEntry projectEntry;
            IMuleDomainProject domainProject;
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            IMuleDomainProject iMuleDomainProject = domainProject = MuleProjectKind.DOMAIN.classifies(project) ? MuleProjectKind.DOMAIN.adapt(project) : null;
            if (domainProject != null) {
                IJavaProject domainJavaProject = domainProject.getJavaProject();
                projectEntry = JavaCore.newProjectEntry((IPath)domainJavaProject.getPath());
            } else {
                projectEntry = JavaCore.newProjectEntry((IPath)new Path("/").append(projectName));
            }
            Consumer<List<IClasspathEntry>> modifyClasspathFunction = entries -> {
                ArrayList entriesToRemove = Lists.newArrayList();
                entries.stream().forEach(entry -> {
                    if (ProjectClasspathUtils.entriesEqualByPath(entry, projectEntry, 1)) {
                        entriesToRemove.add(entry);
                    }
                });
                entries.removeAll(entriesToRemove);
            };
            this.modifyClasspath(muleProject.getJavaProject(), modifyClasspathFunction, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("There was a problem removing a project dependency from: " + String.valueOf(muleProject) + " to " + projectName, e);
        }
    }

    private boolean isEntryARamlFragmentOrRuleset(IClasspathEntry entry) {
        String path = entry.getPath().toString();
        return path.contains("raml-fragment") || path.contains("fat-ruleset");
    }

    public static class IdSupplier {
        private Supplier<String> supplier;

        public static IdSupplier of(ExternalContributionMuleModule module) {
            return new IdSupplier(() -> module.getId());
        }

        public static IdSupplier of(MuleExtension extension) {
            return new IdSupplier(() -> extension.getQualifier());
        }

        public static IdSupplier of(MavenDependency dependency2) {
            return new IdSupplier(() -> MavenUtils.getGAVCT(dependency2));
        }

        private IdSupplier(Supplier<String> supplier) {
            this.supplier = supplier;
        }

        public String getId() {
            return this.supplier.get();
        }
    }
}

