/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.dependencymanagement;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.core.dependencymanagement.RequirementDependencyManager;
import org.mule.tooling.core.m2.MavenResourceUtils;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.dependency.PojoMavenDependency;
import org.mule.tooling.core.m2.dependency.PojoMavenDependencyBuilder;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.Tuple;
import org.mule.tooling.model.module.RequiredAlternatives;
import org.mule.tooling.model.module.RequiredJar;
import org.mule.tooling.model.module.RequiredNativeLibrary;
import org.mule.tooling.model.module.Requirement;
import org.mule.tooling.model.module.RequirementVisitor;
import org.mule.tooling.utils.ObjectHolder;

public abstract class BaseRequirementManager
implements RequirementDependencyManager {
    private int priority;
    private final Map<RequirementDependencyManager.Action, Tuple<String, String>> actionToIdLabelMap;

    public BaseRequirementManager(String addActionId, String addActionLabel, String modifyActionId, String modifyActionLabel) {
        this.actionToIdLabelMap = ImmutableMap.builder().put((Object)RequirementDependencyManager.Action.ADD, Tuple.of(addActionId, addActionLabel)).put((Object)RequirementDependencyManager.Action.MODIFY, Tuple.of(modifyActionId, modifyActionLabel)).build();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public String getLabel(RequirementDependencyManager.Action action) {
        return Optional.of(this.actionToIdLabelMap.get((Object)action)).map(dataTuple -> (String)dataTuple.second()).orElseThrow(this.illegalArgument(action));
    }

    @Override
    public String getActionId(RequirementDependencyManager.Action action) {
        return Optional.of(this.actionToIdLabelMap.get((Object)action)).map(dataTuple -> (String)dataTuple.first()).orElseThrow(this.illegalArgument(action));
    }

    private Supplier<? extends IllegalArgumentException> illegalArgument(RequirementDependencyManager.Action action) {
        return () -> new IllegalArgumentException(action.toString());
    }

    protected static String absoluteLocationToLabel(String absoluteLocation, IMuleProject project) {
        if (absoluteLocation != null) {
            Path path = new Path(absoluteLocation);
            IPath relativeToProjectOrAbsolute = BaseRequirementManager.makeRelativeIfInside((IPath)path, project);
            return relativeToProjectOrAbsolute.toOSString();
        }
        return null;
    }

    protected static IPath makeRelativeIfInside(IPath path, IMuleProject project) {
        return BaseRequirementManager.contains(path, project) ? path.makeRelativeTo(project.getLocation()) : path;
    }

    protected static boolean contains(IPath absolutePath, IMuleProject project) {
        return project.getLocation().isPrefixOf(absolutePath);
    }

    protected Optional<MavenDependency> getSuggestedDependency(final IMuleProject muleProject, Requirement requirement) {
        final ObjectHolder initialDependency = new ObjectHolder();
        requirement.accept(new RequirementVisitor(){

            @Override
            public void visitRequiredJar(RequiredJar requiredJar) {
                requiredJar.getSuggestedCoordinates().map(coordinates -> BaseRequirementManager.this.getDependencyFromData((String)coordinates)).map(dep -> BaseRequirementManager.this.findDependencyInProject(muleProject, (MavenDependency)dep)).map(dep -> BaseRequirementManager.this.asSharedDependency((MavenDependency)dep)).ifPresent(dep -> {
                    Object object = initialDependency.set(dep);
                });
            }

            @Override
            public void visitRequiredAlternatives(RequiredAlternatives requiredAlternatives) {
                requiredAlternatives.accept(this);
            }

            @Override
            public void visitRequiredNativeLib(RequiredNativeLibrary requiredNativeLibrary) {
            }
        });
        return Optional.ofNullable((MavenDependency)initialDependency.or(null));
    }

    private MavenDependency asSharedDependency(MavenDependency dependency2) {
        return ((PojoMavenDependencyBuilder)PojoMavenDependencyBuilder.copyFrom(dependency2).beingShared(true)).build();
    }

    protected boolean promptForUserConfirmation(RequirementDependencyManager.Action action, Shell activeShell, MavenDependency dependency2) {
        String dependencyDescription = this.getDescription(dependency2);
        boolean adding = RequirementDependencyManager.Action.ADD.equals((Object)action);
        String actionDescription = adding ? "added to" : "removed from";
        StringBuilder messageBuilder = new StringBuilder("The following library will be ").append(actionDescription).append(" the project:\n\n\t").append(dependencyDescription).append("\n\nDo you wish to proceed?");
        String string = adding ? "Adding" : "Removing";
        return MessageDialog.openConfirm((Shell)activeShell, (String)(string + " recommended libraries"), (String)messageBuilder.toString());
    }

    protected MavenDependency getDependencyFromData(String data) {
        MavenDependency dependency2 = null;
        if (data.matches("[^\\s]+:[^\\s]+:[^\\s]+")) {
            dependency2 = BaseRequirementManager.getDependencyFromGav(data);
        } else {
            File file = new File(data);
            if (file.exists()) {
                dependency2 = MavenUtils.getDependencyFromPath(file);
            } else {
                throw new IllegalArgumentException("Non-existing successful requirement data: " + data);
            }
        }
        return dependency2;
    }

    protected MavenDependency findDependencyInProject(IMuleProject muleProject, MavenDependency dependency2) {
        String groupId = dependency2.getGroupId();
        String artifactId = dependency2.getArtifactId();
        return muleProject.getMuleProjectModel().getDependencies().stream().filter(dep -> groupId.equals(dep.getGroupId()) && artifactId.equals(dep.getArtifactId())).findFirst().orElse(dependency2);
    }

    private static MavenDependency getDependencyFromGav(String data) {
        String[] split = data.split(":");
        PojoMavenDependency mavenDependency = ((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)PojoMavenDependencyBuilder.newInstance().withGroupId(split[0])).withArtifactId(split[1])).withVersion(split[2])).build();
        Set scopes = Stream.of(MavenDependency.Scope.values()).map(scope -> scope.asString()).collect(Collectors.toSet());
        int i = 3;
        while (i < split.length) {
            String classifierOrScope = split[i];
            if (scopes.contains(classifierOrScope)) {
                MavenDependency.Scope scope2 = MavenDependency.Scope.value(classifierOrScope);
                if (scope2 != null) {
                    mavenDependency.setScope(scope2);
                }
            } else {
                mavenDependency.setClassifier(classifierOrScope);
            }
            ++i;
        }
        return mavenDependency;
    }

    private String getDescription(MavenDependency dependency2) {
        StringBuilder dependencyDescriptionBuilder = new StringBuilder(FilenameUtils.getName((String)MavenResourceUtils.getRepositoryPath(dependency2, File.separator)));
        dependencyDescriptionBuilder.append(" (").append(dependency2.getGroupId()).append(")");
        String dependencyDescription = dependencyDescriptionBuilder.toString();
        return dependencyDescription;
    }

    @Override
    public int compareTo(RequirementDependencyManager other) {
        return other.getPriority() - this.getPriority();
    }

    static /* synthetic */ MavenDependency access$1(BaseRequirementManager baseRequirementManager, MavenDependency mavenDependency) {
        return baseRequirementManager.asSharedDependency(mavenDependency);
    }
}

