/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.dependencymanagement;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.dependencymanagement.RequirementDependencyManager;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.module.RequiredAlternatives;
import org.mule.tooling.model.module.RequiredJar;
import org.mule.tooling.model.module.RequiredNativeLibrary;
import org.mule.tooling.model.module.Requirement;
import org.mule.tooling.model.module.RequirementVisitor;
import org.mule.tooling.utils.SilentRunner;

public class AnalyticsTrackingManagerDecorator
implements RequirementDependencyManager {
    public static final String EVENT_KEY_ACTIONED_DEP = "actionedDependency";
    public static final String EVENT_KEY_ACTION = "action";
    public static final String EVENT_KEY_NODE = "node";
    public static final String EVENT_KEY_PREVIOUS_VALUE = "previousValue";
    public static final String EVENT_KEY_REQ_TYPE = "requirement.type";
    public static final String EVENT_KEY_REQ_NAME = "requirement.name";
    public static final String EVENT_KEY_REQ_CLASSNAME = "requirement.className";
    public static final String EVENT_KEY_REQ_FILENAME = "requirement.fileName";
    public static final String EVENT_KEY_REQ_ALTERNATIVES = "requirement.alternatives";
    private final RequirementDependencyManager decorated;

    public AnalyticsTrackingManagerDecorator(RequirementDependencyManager decorated) {
        this.decorated = decorated;
    }

    @Override
    public final Optional<MavenDependency> run(RequirementDependencyManager.Action action, Shell activeShell, IMuleProject muleProject, IMessageFlowNode node, Requirement requirement, Optional<String> data) {
        SilentRunner.run(() -> this.trackStarted(action, muleProject, node, requirement, data));
        Optional<MavenDependency> actionedDependency = this.decorated.run(action, activeShell, muleProject, node, requirement, data);
        SilentRunner.run(() -> this.trackActionEnd(action, muleProject, node, requirement, data, actionedDependency));
        return actionedDependency;
    }

    private void trackStarted(RequirementDependencyManager.Action action, IMuleProject muleProject, IMessageFlowNode node, Requirement requirement, Optional<String> data) {
        AnalyticsRecordsFactory recordsFactory = AnalyticsRecordsFactory.single(Events.CONFIGURE_REQUIRED_LIBRARY, muleProject);
        this.addBaseEventData(action, node, requirement, data, recordsFactory).track();
    }

    private void trackActionEnd(RequirementDependencyManager.Action action, IMuleProject muleProject, IMessageFlowNode node, Requirement requirement, Optional<String> data, Optional<MavenDependency> actionedDependency) {
        AnalyticsRecordsFactory baseEvent = actionedDependency.map(dependency2 -> AnalyticsRecordsFactory.single(Events.CONFIGURE_REQUIRED_LIBRARY_FINISH, muleProject).addMetadata(EVENT_KEY_ACTIONED_DEP, MavenUtils.getGavString(dependency2))).orElseGet(() -> AnalyticsRecordsFactory.single(Events.CONFIGURE_REQUIRED_LIBRARY_ABANDON, muleProject));
        this.addBaseEventData(action, node, requirement, data, baseEvent);
        baseEvent.track();
    }

    private AnalyticsRecordsFactory addBaseEventData(RequirementDependencyManager.Action action, IMessageFlowNode node, Requirement requirement, Optional<String> data, AnalyticsRecordsFactory recordsFactory) {
        if (node == null) {
            MuleCorePlugin.logWarning("Unexpected missing node", new IllegalArgumentException().fillInStackTrace());
            recordsFactory.addMetadata(EVENT_KEY_NODE, "NODE_MISSING");
        } else if (node.getType() == null) {
            MuleCorePlugin.logWarning("Unexpected missing node type", new IllegalArgumentException().fillInStackTrace());
            recordsFactory.addMetadata(EVENT_KEY_NODE, "NODE_TYPE_MISSING");
        } else {
            recordsFactory.addMetadata(EVENT_KEY_NODE, node.getType());
        }
        recordsFactory.addMetadata(EVENT_KEY_ACTION, this.decorated.getActionId(action));
        this.describe(requirement, recordsFactory);
        data.ifPresent(d -> {
            AnalyticsRecordsFactory analyticsRecordsFactory2 = recordsFactory.addMetadata(EVENT_KEY_PREVIOUS_VALUE, (String)d);
        });
        return recordsFactory;
    }

    private void describe(Requirement requirement, final AnalyticsRecordsFactory recordsFactory) {
        recordsFactory.addMetadata(EVENT_KEY_REQ_TYPE, requirement.getTypeId());
        recordsFactory.addMetadata(EVENT_KEY_REQ_NAME, requirement.getName());
        requirement.accept(new RequirementVisitor(){

            @Override
            public void visitRequiredNativeLib(RequiredNativeLibrary requiredNativeLibrary) {
            }

            @Override
            public void visitRequiredJar(RequiredJar requiredJar) {
                recordsFactory.addMetadata(AnalyticsTrackingManagerDecorator.EVENT_KEY_REQ_CLASSNAME, requiredJar.getClassName());
                recordsFactory.addMetadata(AnalyticsTrackingManagerDecorator.EVENT_KEY_REQ_FILENAME, requiredJar.getFileName());
            }

            @Override
            public void visitRequiredAlternatives(RequiredAlternatives requiredAlternatives) {
                List<? extends Requirement> alternatives = requiredAlternatives.getAlternatives();
                if (alternatives != null) {
                    recordsFactory.addMetadata(AnalyticsTrackingManagerDecorator.EVENT_KEY_REQ_ALTERNATIVES, alternatives.stream().map(Requirement::getName).collect(Collectors.joining(",")));
                    requiredAlternatives.accept(this);
                }
            }
        });
    }

    @Override
    public String getActionId(RequirementDependencyManager.Action action) {
        return this.decorated.getActionId(action);
    }

    @Override
    public String getLabel(RequirementDependencyManager.Action action) {
        return this.decorated.getLabel(action);
    }

    @Override
    public boolean applies(RequirementDependencyManager.Action action, IMuleProject muleProject, Requirement requirement) {
        return this.decorated.applies(action, muleProject, requirement);
    }

    @Override
    public void setPriority(int priority) {
        this.decorated.setPriority(priority);
    }

    @Override
    public int getPriority() {
        return this.decorated.getPriority();
    }

    @Override
    public int compareTo(RequirementDependencyManager o) {
        return this.decorated.compareTo(o);
    }
}

