/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.dependencymanagement;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Optional;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.dependencymanagement.BaseRequirementManager;
import org.mule.tooling.core.dependencymanagement.RequirementDependencyManager;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.runner.ArtifactResolvingRunnerFactory;
import org.mule.tooling.core.module.runner.DependenciesCallback;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.module.Requirement;

public class AddSuggestedRequirementManager
extends BaseRequirementManager {
    private static final String ADD_ACTION_ID = "ADD_RECOMMENDED";
    private static final String ADD_ACTION_LABEL = "Add recommended libraries";

    public AddSuggestedRequirementManager() {
        super(ADD_ACTION_ID, ADD_ACTION_LABEL, "", "");
    }

    @Override
    public boolean applies(RequirementDependencyManager.Action action, IMuleProject muleProject, Requirement requirement) {
        Optional<MavenDependency> suggestedDependency = this.getSuggestedDependency(muleProject, requirement);
        return suggestedDependency.map(suggestedDep -> RequirementDependencyManager.Action.ADD.equals((Object)action) && !this.containsSuggestedDependencies(muleProject, requirement, (MavenDependency)suggestedDep)).orElse(false);
    }

    private boolean containsSuggestedDependencies(IMuleProject muleProject, Requirement requirement, MavenDependency suggestedDep) {
        String suggestedDepGA = MavenUtils.getGA(suggestedDep);
        return muleProject.getMuleProjectModel().getDependencies().stream().anyMatch(dep -> MavenUtils.getGA(dep).equals(suggestedDepGA));
    }

    @Override
    public Optional<MavenDependency> run(RequirementDependencyManager.Action action, Shell activeShell, IMuleProject muleProject, IMessageFlowNode node, Requirement requirement, Optional<String> data) {
        MavenDependency suggestedDependency = this.getSuggestedDependency(muleProject, requirement).orElseThrow(() -> new IllegalStateException());
        boolean confirm = this.promptForUserConfirmation(action, activeShell, suggestedDependency);
        if (confirm) {
            ProgressMonitorDialog progressDialog = this.createProgressDialog(action, activeShell, muleProject, suggestedDependency);
            try {
                progressDialog.run(true, true, monitor -> {
                    if (RequirementDependencyManager.Action.ADD.equals((Object)action)) {
                        ArtifactResolvingRunnerFactory.syncInstance().runResolvingDependencies(muleProject, Arrays.asList(suggestedDependency), DependenciesCallback.builder().onSuccess(dependencies -> muleProject.getMuleProjectModel().addMavenDependency(suggestedDependency)).onErrorLog().build(), monitor);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                MuleCorePlugin.logError("There was a problem adding recommended library " + String.valueOf(suggestedDependency), e);
            }
        }
        return confirm ? Optional.of(suggestedDependency) : Optional.empty();
    }

    protected ProgressMonitorDialog createProgressDialog(final RequirementDependencyManager.Action action, Shell activeShell, final IMuleProject muleProject, final MavenDependency suggestedDependency) {
        return new ProgressMonitorDialog(activeShell){

            protected void configureShell(Shell shell) {
                super.configureShell(shell);
                String titleFormat = RequirementDependencyManager.Action.ADD.equals((Object)action) ? "Adding {0} to {1}" : "Removing {0} from {1}";
                shell.setText(MessageFormat.format(titleFormat, suggestedDependency.getArtifactId(), muleProject.getName()));
            }
        };
    }
}

