/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.classloader;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ClassUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.launching.AbstractVMInstall;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.classloader.MuleClassLoader;
import org.mule.tooling.core.classloader.MuleClassLoaderUtils;
import org.mule.tooling.core.classloader.ProjectClassPath;
import org.mule.tooling.core.classloader.ProjectClassPathProvider;
import org.mule.tooling.core.jvm.JVMHelper;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.runtime.ExternalContributionClasspathContainerInitializer;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.runtime.sources.SourceAttachmentProvider;
import org.mule.tooling.core.runtime.sources.SourceAttachmentProviderExtension;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.utils.SilentRunner;

public class ProjectClasspathUtils {
    private static final String CLASS_EXTENSION = ".class";
    public static final String[] DEFAULT_NATIVE_LIBRARY_RELATIVE_PATHS = new String[]{"src/main/app/lib", "lib"};
    public static final int EXTENSION_NAME_PATH_INDEX = 1;
    public static final int EXTENSION_QUALIFIER_PATH_INDEX = 2;
    public static final int MIN_NUMBER_SEGMENTS_FOR_MULE_LIB = 4;

    public static boolean isUserLibrary(IClasspathEntry entry) {
        if (entry != null && entry.getPath() != null && entry.getPath().segmentCount() > 0) {
            return "org.eclipse.jdt.USER_LIBRARY".equals(entry.getPath().segment(0));
        }
        return false;
    }

    public static boolean isSystemUserLibrary(IClasspathContainer container) {
        return container != null && container.getKind() == 2;
    }

    public static String getJavaVersion(IJavaProject javaProject) throws CoreException {
        IVMInstall vm = JavaRuntime.getVMInstall((IJavaProject)javaProject);
        if (vm instanceof AbstractVMInstall) {
            AbstractVMInstall install = (AbstractVMInstall)vm;
            return install.getJavaVersion();
        }
        throw new IllegalArgumentException("Obtained an unexpected kind of VM install: " + String.valueOf(vm));
    }

    public static String getShortJavaVersion(IJavaProject project) throws CoreException {
        IVMInstall vm = JVMHelper.getVMInstallByProject(project);
        return JavaModelUtil.getCompilerCompliance((IVMInstall2)((IVMInstall2)vm), null);
    }

    public static Class<?> loadClass(final String name, final IMuleProject muleProject) {
        return (Class)SilentRunner.run((Callable)new Callable<Class<?>>(){

            @Override
            public Class<?> call() throws Exception {
                Class clazz;
                MuleClassLoader cl = null;
                try {
                    ProjectClassPathProvider projectClassPathProvider = new ProjectClassPathProvider();
                    URL[] serverClassPath = projectClassPathProvider.getServerClassPath(muleProject);
                    MuleClassLoader runtimeServer = MuleClassLoaderUtils.createMuleClassLoader(serverClassPath, IMuleProject.class.getClassLoader());
                    URL[] urls = projectClassPathProvider.getClassPath(muleProject).getUrls();
                    cl = MuleClassLoaderUtils.createMuleClassLoader(urls, runtimeServer);
                    clazz = ClassUtils.getClass((ClassLoader)cl, (String)name, (boolean)true);
                }
                catch (Throwable throwable) {
                    MuleClassLoaderUtils.dispose(cl);
                    throw throwable;
                }
                MuleClassLoaderUtils.dispose(cl);
                return clazz;
            }
        }, null);
    }

    public static void executeOnProjectClassloader(IMuleProject muleProject, Consumer<ClassLoader> consumer) {
        block5: {
            MuleClassLoader cl = null;
            try {
                try {
                    ProjectClassPathProvider projectClassPathProvider = new ProjectClassPathProvider();
                    URL[] serverClassPath = projectClassPathProvider.getServerClassPath(muleProject);
                    MuleClassLoader runtimeServer = MuleClassLoaderUtils.createMuleClassLoader(serverClassPath, IMuleProject.class.getClassLoader());
                    URL[] urls = projectClassPathProvider.getClassPath(muleProject).getUrls();
                    cl = MuleClassLoaderUtils.createMuleClassLoader(urls, runtimeServer);
                    consumer.accept(cl);
                }
                catch (MalformedURLException | JavaModelException e) {
                    e.printStackTrace();
                    MuleClassLoaderUtils.dispose(cl);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                MuleClassLoaderUtils.dispose(cl);
                throw throwable;
            }
            MuleClassLoaderUtils.dispose(cl);
        }
    }

    public static Collection<String> getDefaultProjectNativeLibraryPaths(IJavaProject javaProject) {
        HashSet<String> nativeLibraryPaths = new HashSet<String>();
        String[] stringArray = DEFAULT_NATIVE_LIBRARY_RELATIVE_PATHS;
        int n = DEFAULT_NATIVE_LIBRARY_RELATIVE_PATHS.length;
        int n2 = 0;
        while (n2 < n) {
            String absolutePath;
            String defaultNativeLibrary = stringArray[n2];
            IPath location = javaProject.getProject().getLocation();
            if (location != null && new File(absolutePath = location.append(defaultNativeLibrary).toFile().getAbsolutePath()).exists() && !nativeLibraryPaths.contains(absolutePath)) {
                nativeLibraryPaths.add(absolutePath);
            }
            ++n2;
        }
        return nativeLibraryPaths;
    }

    public static IPath getJarInsideClassPath(String fileName, IMuleProject project) {
        return ProjectClasspathUtils.findMatchInClasspath(fileName, project, match -> {
            if (match.toFile().exists()) {
                return com.google.common.base.Optional.of((Object)match);
            }
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IResource res = root.findMember(match);
            return com.google.common.base.Optional.fromNullable((Object)res).transform(IT -> IT.getLocation());
        });
    }

    public static String getJarPathIfInsideClassPath(String className, IMuleProject project) {
        try {
            ProjectClassPath projectClasspath = new ProjectClassPathProvider().getClassPath(project);
            URLClassLoader classLoader = new URLClassLoader(projectClasspath.getUrls());
            Class<?> clazz = Class.forName(className, false, classLoader);
            String path = new File(clazz.getProtectionDomain().getCodeSource().getLocation().toURI()).getPath();
            return path;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isClassInsideJar(String className, File jar) {
        try {
            var2_2 = null;
            var3_5 = null;
            try {
                zip = new ZipInputStream(new FileInputStream(jar));
                try {
                    entry = zip.getNextEntry();
                    while (true) {
                        if (entry.getName().endsWith(".class") && !entry.isDirectory()) {
                            jarClassName = new StringBuilder();
                            var10_13 = entry.getName().split("/");
                            var9_12 = var10_13.length;
                            var8_11 = 0;
                            while (var8_11 < var9_12) {
                                part = var10_13[var8_11];
                                if (jarClassName.length() != 0) {
                                    jarClassName.append(".");
                                }
                                jarClassName.append(part);
                                if (part.endsWith(".class")) {
                                    jarClassName.setLength(jarClassName.length() - ".class".length());
                                }
                                ++var8_11;
                            }
                            if (className.equals(jarClassName.toString())) {
                                return true;
                            }
                        }
                        entry = zip.getNextEntry();
                        return (boolean)entry;
                    }
                }
                finally {
                    if (entry != null) ** continue;
                    return false;
                }
            }
            catch (Throwable var3_6) {
                if (var2_2 == null) {
                    var2_2 = var3_6;
                    throw var2_2;
                }
                if (var2_2 == var3_6) throw var2_2;
                var2_2.addSuppressed(var3_6);
                throw var2_2;
            }
        }
        catch (Exception e) {
            MuleCorePlugin.logWarning("Cannot find class " + className + " inside library " + (jar != null ? jar.getAbsolutePath() : null), e);
            return false;
        }
    }

    public static Collection<String> getProjectNativeLibraryPaths(IJavaProject javaProject) throws CoreException {
        HashSet<String> nativeLibraryPaths = new HashSet<String>(ProjectClasspathUtils.getDefaultProjectNativeLibraryPaths(javaProject));
        ProjectClasspathUtils.processClassPathEntries(javaProject.getRawClasspath(), javaProject, nativeLibraryPaths);
        return nativeLibraryPaths;
    }

    private static void processClassPathEntries(IClasspathEntry[] entries, IJavaProject javaProject, Collection<String> nativeLibraryPaths) throws CoreException {
        if (entries != null) {
            IClasspathEntry[] iClasspathEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry != null) {
                    IClasspathContainer container;
                    ProjectClasspathUtils.processClassPathEntryAttributes(entry, nativeLibraryPaths, javaProject);
                    if (entry.getEntryKind() == 5 && (container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)javaProject)) != null) {
                        ProjectClasspathUtils.processClassPathEntries(container.getClasspathEntries(), javaProject, nativeLibraryPaths);
                    }
                }
                ++n2;
            }
        }
    }

    private static void processClassPathEntryAttributes(IClasspathEntry entry, Collection<String> nativeLibraryPaths, IJavaProject javaProject) {
        String libraryPath = ProjectClasspathUtils.getAssociatedNativeLibraryPath(entry.getExtraAttributes(), javaProject);
        if (libraryPath != null && !nativeLibraryPaths.contains(libraryPath)) {
            nativeLibraryPaths.add(libraryPath);
        }
    }

    public static void removeClasspathEntry(IJavaProject javaProject, IClasspathEntry entry, IProgressMonitor monitor, int segmentCount) throws CoreException {
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>(Arrays.asList(javaProject.getRawClasspath()));
        for (IClasspathEntry _entry : new ArrayList<IClasspathEntry>(entries)) {
            if (!ProjectClasspathUtils.entriesEqualByPath(_entry, entry, segmentCount)) continue;
            entries.remove(_entry);
        }
        javaProject.setRawClasspath(entries.toArray(new IClasspathEntry[entries.size()]), monitor);
        javaProject.getProject().refreshLocal(1, monitor);
    }

    public static boolean entriesEqualByPath(IClasspathEntry anEntry, IClasspathEntry anotherEntry, int segmentCount) {
        IPath aPath = anEntry.getPath();
        IPath anotherPath = anotherEntry.getPath();
        return ProjectClasspathUtils.pathEquals(aPath, anotherPath, segmentCount);
    }

    private static boolean pathEquals(IPath aPath, IPath anotherPath, int segmentCount) {
        if (aPath == null && anotherPath == null) {
            return true;
        }
        if (aPath == null && anotherPath != null || aPath != null && anotherPath == null) {
            return false;
        }
        int minSegmentCount = Math.min(aPath.segmentCount(), anotherPath.segmentCount());
        if (minSegmentCount < segmentCount) {
            if (aPath.segmentCount() == anotherPath.segmentCount()) {
                return ProjectClasspathUtils.pathEquals(aPath, anotherPath, minSegmentCount);
            }
            return false;
        }
        int i = 0;
        while (i < Math.min(minSegmentCount, segmentCount)) {
            if (!aPath.segment(i).equals(anotherPath.segment(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void removeClasspathEntry(IPath containerPath, IJavaProject javaProject, int segmentCount) throws CoreException {
        IClasspathEntry newContainerEntry = JavaCore.newContainerEntry((IPath)containerPath, (boolean)false);
        ProjectClasspathUtils.removeClasspathEntry(javaProject, newContainerEntry, null, segmentCount);
    }

    public static void addNewClasspathEntry(IJavaProject javaProject, IClasspathEntry entry, IProgressMonitor monitor) throws JavaModelException {
        monitor.beginTask("Adding new classpath entry to project: " + javaProject.getProject().getName(), 100);
        try {
            Object[] classpathEntries = javaProject.getRawClasspath();
            monitor.worked(50);
            classpathEntries = (IClasspathEntry[])ArrayUtils.add((Object[])classpathEntries, (Object)entry);
            javaProject.setRawClasspath((IClasspathEntry[])classpathEntries, monitor);
            monitor.worked(50);
        }
        finally {
            monitor.done();
        }
    }

    public static void reinitializeClasspathContainer(IJavaProject javaProject, IPath entryPath) throws CoreException {
        if (CoreUtils.isMuleExtensionContainer(entryPath)) {
            ExternalContributionClasspathContainerInitializer externalContributionClasspathContainerInitializer = new ExternalContributionClasspathContainerInitializer();
            externalContributionClasspathContainerInitializer.initialize(entryPath, javaProject);
        } else {
            ClasspathContainerInitializer classpathContainerInitializer = JavaCore.getClasspathContainerInitializer((String)entryPath.segment(0));
            if (classpathContainerInitializer != null) {
                classpathContainerInitializer.initialize(entryPath, javaProject);
            }
        }
    }

    public static boolean isClasspathEntryInProject(IPath entryPath, IJavaProject javaProject) throws JavaModelException {
        return ProjectClasspathUtils.isClasspathEntryInProject(entryPath, javaProject.getRawClasspath());
    }

    public static boolean isClasspathEntryInProject(IClasspathContainer entry, IJavaProject javaProject) throws JavaModelException {
        return ProjectClasspathUtils.isClasspathEntryInProject(entry.getPath(), javaProject);
    }

    public static boolean isClasspathEntryInProject(IPath path, IClasspathEntry[] rawClasspath) {
        return ProjectClasspathUtils.isClasspathEntryInProject(path, rawClasspath, 4);
    }

    public static boolean isClasspathEntryInProject(IPath path, IClasspathEntry[] rawClasspath, int numberOfSegments) {
        IClasspathEntry[] iClasspathEntryArray = rawClasspath;
        int n = rawClasspath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
            if (ProjectClasspathUtils.pathEquals(path, classpathEntry.getPath(), numberOfSegments)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getAssociatedNativeLibraryPath(IClasspathAttribute[] extraAttributes, IJavaProject javaProject) {
        if (extraAttributes != null) {
            IClasspathAttribute[] iClasspathAttributeArray = extraAttributes;
            int n = extraAttributes.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathAttribute classpathAttribute = iClasspathAttributeArray[n2];
                if (JavaRuntime.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY.equals(classpathAttribute.getName())) {
                    String pathStr = new Path(classpathAttribute.getValue()).toOSString();
                    File path = new File(pathStr);
                    if (!path.exists()) {
                        IProject project;
                        int idxOfFileSeparator = pathStr.indexOf(File.separator);
                        String projectName = null;
                        String nativeLibRelativePath = null;
                        if (idxOfFileSeparator > 0) {
                            projectName = pathStr.substring(0, idxOfFileSeparator);
                            nativeLibRelativePath = pathStr.substring(idxOfFileSeparator + 1);
                        } else {
                            projectName = pathStr;
                            nativeLibRelativePath = "";
                        }
                        if (new Path(projectName).segmentCount() == 1 && (project = javaProject.getProject().getWorkspace().getRoot().getProject(projectName)).exists()) {
                            IPath rawLocation = project.getRawLocation();
                            IPath location = rawLocation != null ? rawLocation : project.getLocation();
                            path = new File(String.valueOf(location) + File.separator + nativeLibRelativePath);
                        }
                        if (!path.exists()) {
                            MuleCorePlugin.logWarning("Cannot define absolute native library path from value [" + pathStr + "]. Please check your project classpath configuration as the operation you are trying to execute may fail.", null);
                            return null;
                        }
                    }
                    if (!path.isDirectory()) {
                        return null;
                    }
                    return path.getAbsolutePath();
                }
                ++n2;
            }
        }
        return null;
    }

    public static boolean addNatureId(IProjectDescription description, String natureId) {
        boolean success;
        HashSet<String> natures = new HashSet<String>(Arrays.asList(description.getNatureIds()));
        natures.add(natureId);
        String[] newNatures = natures.toArray(new String[natures.size()]);
        IStatus status = ResourcesPlugin.getWorkspace().validateNatureSet(newNatures);
        boolean bl = success = status.getCode() == 0;
        if (success) {
            description.setNatureIds(newNatures);
        }
        return success;
    }

    public static void removeNatureId(IProjectDescription description, String natureId) {
        ArrayList<String> natures = new ArrayList<String>(Arrays.asList(description.getNatureIds()));
        natures.remove(natureId);
        String[] newNatures = natures.toArray(new String[natures.size()]);
        description.setNatureIds(newNatures);
    }

    public static IStatus ensureFolderIsASourceFolder(IMuleProject muleProject, IFolder folder) throws JavaModelException {
        IClasspathEntry[] rawClasspath;
        boolean found = false;
        Path path = new Path(folder.getProjectRelativePath().toString());
        IJavaProject javaProject = muleProject.getJavaProject();
        IClasspathEntry[] iClasspathEntryArray = rawClasspath = javaProject.getRawClasspath();
        int n = rawClasspath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            IPath projectRelativeEntryPath = entry.getPath().makeRelativeTo(javaProject.getPath());
            if (entry.getEntryKind() == 3 && projectRelativeEntryPath.equals((Object)path)) {
                found = true;
                break;
            }
            ++n2;
        }
        if (!found) {
            try {
                IPath entryPath = javaProject.getPath().append(folder.getProjectRelativePath());
                IClasspathEntry entry = JavaCore.newSourceEntry((IPath)entryPath);
                muleProject.modifyClasspath(entries -> {
                    boolean bl = entries.add(entry);
                }, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (JavaModelException javaModelException) {
                return new Status(8, "org.mule.tooling.core", "There was a problem setting " + String.valueOf(path) + " as a source folder for project " + muleProject.getName());
            }
        }
        return Status.OK_STATUS;
    }

    public static void setResourceAsDerived(IResource resource) {
        try {
            resource.setDerived(true, null);
        }
        catch (Exception e) {
            MuleCorePlugin.logError("Error setting resource " + resource.getName() + " as derived", e);
        }
    }

    public static IPath findMatchInClasspath(String partialName, IMuleProject project, PathFilter pathFilter) {
        try {
            IJavaProject javaProject = project.getJavaProject();
            IClasspathEntry[] rawClasspath = javaProject.getRawClasspath();
            return ProjectClasspathUtils.findInClasspath(partialName, rawClasspath, project, pathFilter);
        }
        catch (Exception e) {
            MuleCorePlugin.logError("Error searching classpath entry matching " + partialName + " in classpath", e);
            return null;
        }
    }

    private static IPath findInClasspath(String partialName, IClasspathEntry[] classpathEntries, IMuleProject project, PathFilter pathFilter) throws JavaModelException {
        if (partialName != null && classpathEntries != null) {
            IClasspathEntry[] iClasspathEntryArray = classpathEntries;
            int n = classpathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 5) {
                    IPath foundInContainer;
                    IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)project.getJavaProject());
                    if (container != null && (foundInContainer = ProjectClasspathUtils.findInClasspath(partialName, container.getClasspathEntries(), project, pathFilter)) != null) {
                        return foundInContainer;
                    }
                } else {
                    IPath absolutePath = null;
                    if (entry.getEntryKind() == 4) {
                        absolutePath = CoreUtils.getPathForVariableClasspathEntry(entry);
                    } else if (entry.getEntryKind() == 1 && ProjectClasspathUtils.getLibFileName(entry).matches(partialName)) {
                        absolutePath = CoreUtils.getPathForLibraryClasspathEntry(entry, project.getJavaProject());
                    }
                    if (absolutePath != null) {
                        File file = absolutePath.toFile();
                        if (file.isFile()) {
                            com.google.common.base.Optional mapped;
                            String entryName = file.getName();
                            if (entryName.matches(partialName) && (mapped = (com.google.common.base.Optional)pathFilter.apply(absolutePath)).isPresent()) {
                                return (IPath)mapped.get();
                            }
                        } else {
                            IPath foundInFolder = ProjectClasspathUtils.checkFilesInFolder(partialName, file, pathFilter);
                            if (foundInFolder != null) {
                                return foundInFolder;
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    private static String getLibFileName(IClasspathEntry entry) {
        String libFileName = entry.getPath().lastSegment();
        if (!libFileName.endsWith(".jar") && entry.getExtraAttributes().length > 0) {
            IClasspathAttribute[] iClasspathAttributeArray = entry.getExtraAttributes();
            int n = iClasspathAttributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathAttribute attribute = iClasspathAttributeArray[n2];
                if (JavaRuntime.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY.equals(attribute.getName())) {
                    libFileName = attribute.getValue();
                    int p = libFileName.lastIndexOf(File.separator);
                    if (p <= 0) break;
                    libFileName = libFileName.substring(p + 1);
                    break;
                }
                ++n2;
            }
        }
        return libFileName;
    }

    private static IPath checkFilesInFolder(String partialName, File folder, PathFilter pathFilter) {
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath asPath;
            com.google.common.base.Optional mapped;
            File file = fileArray[n2];
            String entryName = file.getName();
            if (entryName.matches(partialName) && (mapped = (com.google.common.base.Optional)pathFilter.apply(asPath = Path.fromOSString((String)file.getAbsolutePath()))).isPresent()) {
                return (IPath)mapped.get();
            }
            ++n2;
        }
        return null;
    }

    public static boolean hasAJavaRuntimeClasspathContainer(IJavaProject javaProject, IProgressMonitor progressMonitor) throws JavaModelException {
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>(Arrays.asList(javaProject.getRawClasspath()));
        return entries.stream().anyMatch(ProjectClasspathUtils::isJavaContainer);
    }

    public static Optional<IClasspathEntry> getJavaRuntimeClasspathContainer(IJavaProject javaProject, IProgressMonitor progressMonitor) throws JavaModelException {
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>(Arrays.asList(javaProject.getRawClasspath()));
        return entries.stream().filter(ProjectClasspathUtils::isJavaContainer).findFirst();
    }

    public static void addDefaultJavaRuntimeClasspathContainer(IJavaProject javaProject, IProgressMonitor progressMonitor) throws JavaModelException {
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>(Arrays.asList(javaProject.getRawClasspath()));
        entries.add(JavaRuntime.getDefaultJREContainerEntry());
        javaProject.setRawClasspath(entries.toArray(new IClasspathEntry[entries.size()]), progressMonitor);
    }

    public static IPath getSourceAttachment(IServerDefinition server, IPath path) {
        com.google.common.base.Optional<IPath> sourceAttachment = com.google.common.base.Optional.absent();
        Iterator<SourceAttachmentProvider> providers = SourceAttachmentProviderExtension.getProviders().iterator();
        do {
            sourceAttachment = providers.next().getSourceAttachment(path, server);
        } while (providers.hasNext() && !sourceAttachment.isPresent());
        return (IPath)sourceAttachment.orNull();
    }

    public static IClasspathEntry[] getUpdatedClasspathEntries(IClasspathContainer originalContainer, IClasspathContainer containerSuggestion) {
        IClasspathEntry[] originalEntries = originalContainer.getClasspathEntries();
        IClasspathEntry[] newEntries = (IClasspathEntry[])Array.newInstance(IClasspathEntry.class, originalEntries.length);
        Map<IPath, IClasspathEntry> updatedEntriesMap = ProjectClasspathUtils.mapByPath(containerSuggestion.getClasspathEntries());
        int i = 0;
        while (i < originalEntries.length) {
            IClasspathEntry originalEntry = originalEntries[i];
            IClasspathEntry updatedEntry = updatedEntriesMap.get(originalEntry.getPath());
            boolean considerUpdatedEntry = updatedEntry != null && ProjectClasspathUtils.sourcesChanged(originalEntry, updatedEntry);
            newEntries[i] = considerUpdatedEntry ? updatedEntry : originalEntry;
            ++i;
        }
        return newEntries;
    }

    public static boolean sourcesChanged(IClasspathEntry original, IClasspathEntry updated) {
        boolean equalsButSources = true;
        equalsButSources &= !ProjectClasspathUtils.nullSafeEquals(original.getSourceAttachmentPath(), updated.getSourceAttachmentPath());
        equalsButSources &= original.getEntryKind() == updated.getEntryKind();
        equalsButSources &= original.getContentKind() == updated.getContentKind();
        equalsButSources &= ProjectClasspathUtils.nullSafeEquals(original.getPath(), updated.getPath());
        return equalsButSources &= ProjectClasspathUtils.nullSafeEquals(original.getSourceAttachmentRootPath(), updated.getSourceAttachmentRootPath());
    }

    private static <T> boolean nullSafeEquals(T object1, T object2) {
        return object1 != null ? object1.equals(object2) : object2 == null;
    }

    public static Map<IPath, IClasspathEntry> mapByPath(IClasspathEntry[] entries) {
        return Arrays.stream(entries).collect(Collectors.toMap(IClasspathEntry::getPath, Function.identity()));
    }

    public static boolean isJavaContainer(IClasspathEntry entry) {
        IPath path = entry.getPath();
        return path.segmentCount() > 0 && JavaRuntime.JRE_CONTAINER.equals(path.segment(0));
    }

    public static ISchedulingRule getClasspathModificationRule(IJavaProject javaProject) {
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        return new MultiRule(new ISchedulingRule[]{ruleFactory.modifyRule((IResource)javaProject.getProject()), ruleFactory.modifyRule((IResource)JavaModelManager.getExternalManager().getExternalFoldersProject())});
    }

    static interface PathFilter
    extends Function<IPath, com.google.common.base.Optional<IPath>> {
    }
}

