/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.classloader;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.classloader.ProjectClassPath;
import org.mule.tooling.core.classloader.ProjectClasspathUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.runtime.MuleClasspathContainer;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.ClasspathCollection;
import org.mule.tooling.core.utils.CoreUtils;

public class ProjectClassPathProvider {
    public Set<URL> getServerClassPath(String runtimeId) throws CoreException, MalformedURLException {
        IServerDefinition server = MuleCorePlugin.getServerManager().getServerDefinition(runtimeId);
        if (server == null) {
            throw new CoreException(MuleCorePlugin.createStatus(4, "Server referenced by launch (version " + runtimeId + ") does not exist!", null));
        }
        return this.getServerClassPath(server);
    }

    private Set<URL> getServerClassPath(IServerDefinition server) throws CoreException, MalformedURLException {
        String[] serverClasspathElements;
        String[] libraryPathsForClasspath;
        if (server == null) {
            throw new IllegalArgumentException("Server cannot be null");
        }
        LinkedHashSet<File> updatedFiles = new LinkedHashSet<File>();
        Set<String> bannedArtifacts = MuleCorePlugin.getInstance().getBlocklistedArtifacts();
        String[] stringArray = libraryPathsForClasspath = CoreUtils.getServerLibraryPathsForClasspath(server);
        int n = libraryPathsForClasspath.length;
        int n2 = 0;
        while (n2 < n) {
            String libPath = stringArray[n2];
            File[] libFiles = new File(libPath).listFiles();
            if (libFiles != null) {
                File[] fileArray = libFiles;
                int n3 = libFiles.length;
                int n4 = 0;
                while (n4 < n3) {
                    File lib = fileArray[n4];
                    if (!this.isBannedJar(lib, bannedArtifacts)) {
                        updatedFiles.add(lib);
                    }
                    ++n4;
                }
            } else {
                MuleCorePlugin.logInfo("While generating classpath found that " + libPath + " is not a directory.");
            }
            ++n2;
        }
        String[] stringArray2 = serverClasspathElements = CoreUtils.getServerClasspathElements(server);
        int n5 = serverClasspathElements.length;
        n = 0;
        while (n < n5) {
            String libPath = stringArray2[n];
            updatedFiles.add(new File(libPath));
            ++n;
        }
        LinkedHashSet<URL> updatedUrls = new LinkedHashSet<URL>();
        for (File lib : updatedFiles) {
            updatedUrls.add(lib.toURI().toURL());
        }
        return updatedUrls;
    }

    public URL[] getServerClassPath(IMuleProject muleproject) {
        try {
            Set<URL> serverClassPath = this.getServerClassPath(muleproject.getRuntimeId());
            return serverClassPath.toArray(new URL[serverClassPath.size()]);
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public ProjectClassPath getClassPath(IMuleProject muleProject) throws JavaModelException, MalformedURLException {
        ClasspathCollection urls = new ClasspathCollection();
        HashSet<String> nativeLibraryPaths = new HashSet<String>();
        this.addClassPath(muleProject, urls, nativeLibraryPaths, muleProject.getServerDefinition());
        return new ProjectClassPath(urls.toArray(new URL[urls.size()]), nativeLibraryPaths.toArray(new String[nativeLibraryPaths.size()]));
    }

    private void addClassPath(IMuleProject muleProject, Collection<URL> urls, Collection<String> nativeLibraryPaths, IServerDefinition serverDefinition) throws JavaModelException, MalformedURLException {
        this.addClassPath(muleProject, null, urls, nativeLibraryPaths, null, serverDefinition);
    }

    private void addClassPath(IMuleProject muleProject, ExternalContributionMuleModule module, Collection<URL> urls, Collection<String> nativeLibraryPaths, Set<String> bannedArtifacts, IServerDefinition serverDefinition) throws JavaModelException, MalformedURLException {
        IClasspathEntry entry2;
        if (muleProject == null) {
            return;
        }
        IJavaProject javaProject = muleProject.getJavaProject();
        if (javaProject == null) {
            return;
        }
        if (nativeLibraryPaths != null) {
            nativeLibraryPaths.addAll(ProjectClasspathUtils.getDefaultProjectNativeLibraryPaths(javaProject));
        }
        ResolvedClasspath resolved = new ResolvedClasspath();
        IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            entry2 = iClasspathEntryArray[n2];
            if (entry2 != null) {
                this.resolve(entry2, muleProject, module, resolved, nativeLibraryPaths, serverDefinition);
            }
            ++n2;
        }
        iClasspathEntryArray = javaProject.getReferencedClasspathEntries();
        n = iClasspathEntryArray.length;
        n2 = 0;
        while (n2 < n) {
            entry2 = iClasspathEntryArray[n2];
            if (entry2 != null) {
                this.resolve(entry2, muleProject, module, resolved, nativeLibraryPaths, serverDefinition);
            }
            ++n2;
        }
        for (IClasspathEntry entry2 : resolved.getResolvedEntries()) {
            switch (entry2.getEntryKind()) {
                case 1: {
                    File file = entry2.getPath().makeAbsolute().toFile();
                    if (!file.exists()) {
                        boolean isLibraryAvailable = this.checkResourceInsideProject(entry2.getPath());
                        if (isLibraryAvailable) {
                            file = this.resourceRelativePathToFile(entry2.getPath());
                        } else {
                            throw new RuntimeException("There are some error in the current classpath");
                        }
                    }
                    if (this.isBannedJar(file, bannedArtifacts)) break;
                    urls.add(this.toURL(file));
                    break;
                }
                case 3: {
                    IPath outdir = entry2.getOutputLocation();
                    if (outdir == null) {
                        outdir = javaProject.getOutputLocation();
                    }
                    if (outdir == null) break;
                    File file = null;
                    file = !outdir.toFile().exists() ? this.resourceRelativePathToFile(outdir) : outdir.toFile();
                    urls.add(this.toURL(file));
                    break;
                }
                case 2: {
                    IProject refProject = ResourcesPlugin.getWorkspace().getRoot().getProject(entry2.getPath().lastSegment());
                    try {
                        this.addClassPath((IMuleProject)MuleRuntime.create(refProject), urls, nativeLibraryPaths, serverDefinition);
                        break;
                    }
                    catch (CoreException e) {
                        throw new JavaModelException(e);
                    }
                }
            }
        }
        if (!resolved.isModuleContainerProcessed()) {
            try {
                if (module != null) {
                    for (String aJar : CoreUtils.getExternalContributionsLibsWithDependenciesAsString(module)) {
                        File file = new File(aJar);
                        if (this.isBannedJar(file, bannedArtifacts)) continue;
                        urls.add(this.toURL(file));
                    }
                }
            }
            catch (IOException ioEx) {
                MuleCorePlugin.logError("Could not retrieve dependencies for " + String.valueOf(module), ioEx);
            }
        }
        String projectRoot = javaProject.getProject().getLocation().toOSString();
        String projectOutputDir = new File(javaProject.getOutputLocation().toOSString()).getName();
        urls.add(new File(projectRoot, projectOutputDir).toURI().toURL());
    }

    private File resourceRelativePathToFile(IPath resourcePath) {
        String projectName = resourcePath.segment(0);
        IPath relativeToProjectLibraryPath = resourcePath.removeFirstSegments(1);
        IPath projectLocation = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getLocation();
        return projectLocation.append(relativeToProjectLibraryPath).toFile();
    }

    private boolean checkResourceInsideProject(IPath resourcePath) {
        String projectName = resourcePath.segment(0);
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getLocation() != null;
    }

    private boolean isBannedJar(File file, Set<String> bannedArtifacts) {
        if (bannedArtifacts != null && bannedArtifacts.size() > 0) {
            String filename = file.getName();
            return bannedArtifacts.contains(CoreUtils.getArtifactIdFromFilename(filename));
        }
        return false;
    }

    private void resolve(IClasspathEntry entry, IMuleProject project, ExternalContributionMuleModule module, ResolvedClasspath resolved, Collection<String> nativeLibraryPaths, IServerDefinition serverDefinition) throws JavaModelException {
        if (entry == null) {
            return;
        }
        String libraryPath = ProjectClasspathUtils.getAssociatedNativeLibraryPath(entry.getExtraAttributes(), project.getJavaProject());
        if (libraryPath != null) {
            nativeLibraryPaths.add(libraryPath);
        }
        switch (entry.getEntryKind()) {
            case 5: {
                IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)project.getJavaProject());
                if (container != null && 1 == container.getKind() && !ProjectClasspathUtils.isUserLibrary(entry)) {
                    if (module != null) {
                        this.processApplicationContainer(container, project, module, resolved, nativeLibraryPaths, serverDefinition);
                        break;
                    }
                    this.processApplicationContainer(container, project, resolved, nativeLibraryPaths, serverDefinition);
                    break;
                }
                if (!ProjectClasspathUtils.isUserLibrary(entry)) break;
                this.processApplicationContainer(container, project, resolved, nativeLibraryPaths, serverDefinition);
                break;
            }
            case 1: 
            case 3: {
                resolved.addEntry(entry);
                break;
            }
            case 4: {
                this.resolve(JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry), project, module, resolved, nativeLibraryPaths, serverDefinition);
                break;
            }
            case 2: {
                resolved.addEntry(entry);
            }
        }
    }

    private void processApplicationContainer(IClasspathContainer container, IMuleProject project, ResolvedClasspath resolved, Collection<String> nativeLibraryPaths, IServerDefinition serverDefinition) throws JavaModelException {
        this.innerProcessApplicationContainer(container, project, null, resolved, nativeLibraryPaths, serverDefinition);
    }

    private void processApplicationContainer(IClasspathContainer container, IMuleProject muleProject, ExternalContributionMuleModule module, ResolvedClasspath resolved, Collection<String> nativeLibraryPaths, IServerDefinition serverDefinition) throws JavaModelException {
        IPath containerPath = container.getPath();
        if (!MuleClasspathContainer.isMuleRuntime(containerPath)) {
            List<ExternalContributionMuleModule> externalModulesFromContainerIPath = CoreUtils.getExternalModulesFromContainerIPath(containerPath, muleProject);
            if (module != null && externalModulesFromContainerIPath.size() > 0) {
                if (externalModulesFromContainerIPath.contains(module)) {
                    this.innerProcessApplicationContainer(container, muleProject, module, resolved, nativeLibraryPaths, serverDefinition);
                    resolved.setModuleContainer(container);
                } else {
                    for (ExternalContributionMuleModule externalModule : externalModulesFromContainerIPath) {
                        if (!externalModule.isIncludeInDesignTimeClasspath()) continue;
                        this.innerProcessApplicationContainer(container, muleProject, module, resolved, nativeLibraryPaths, serverDefinition);
                        break;
                    }
                    ExternalContributionMuleModule externalContributionMuleModule = externalModulesFromContainerIPath.get(0);
                    System.out.println("Not adding " + externalContributionMuleModule.getName() + " [" + externalContributionMuleModule.getContributionVersion() + "] jars to the DataSense service classpath!");
                }
            }
        }
    }

    private void innerProcessApplicationContainer(IClasspathContainer container, IMuleProject project, ExternalContributionMuleModule module, ResolvedClasspath resolved, Collection<String> nativeLibraryPaths, IServerDefinition serverDefinition) throws JavaModelException {
        IClasspathEntry[] iClasspathEntryArray = container.getClasspathEntries();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry containerEntry = iClasspathEntryArray[n2];
            this.resolve(containerEntry, project, module, resolved, nativeLibraryPaths, serverDefinition);
            ++n2;
        }
    }

    private URL toURL(File file) throws MalformedURLException {
        if (file.isDirectory()) {
            Object url = file.toURI().toURL().toExternalForm();
            if (!((String)url).endsWith("/")) {
                url = (String)url + "/";
            }
            return new URL((String)url);
        }
        return file.toURI().toURL();
    }

    private class ResolvedClasspath {
        private final List<IClasspathEntry> resolved = new LinkedList<IClasspathEntry>();
        private IClasspathContainer moduleContainer = null;

        private ResolvedClasspath() {
        }

        public void addEntry(IClasspathEntry entry) {
            this.resolved.add(entry);
        }

        public Iterable<IClasspathEntry> getResolvedEntries() {
            return this.resolved;
        }

        public void setModuleContainer(IClasspathContainer moduleContainer) {
            this.moduleContainer = moduleContainer;
        }

        public boolean isModuleContainerProcessed() {
            return this.moduleContainer != null;
        }
    }
}

