/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.classloader;

import java.awt.Toolkit;
import java.net.Authenticator;
import java.net.URL;
import java.sql.DriverManager;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.classloader.MuleClassLoader;
import org.mule.tooling.core.classloader.ProjectClassPath;
import org.mule.tooling.core.classloader.ProjectClassPathProvider;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.utils.SilentRunner;

public class MuleClassLoaderUtils {
    private static Authenticator STUDIO_AUTHENTICATOR;
    private static final AtomicBoolean initialized;

    static {
        initialized = new AtomicBoolean(false);
    }

    public static void init() {
        STUDIO_AUTHENTICATOR = CoreUtils.getCurrentAuthenticator();
        if (initialized.compareAndSet(false, true)) {
            MuleClassLoaderUtils.scheduleInit();
        }
    }

    private static void scheduleInit() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MuleClassLoaderUtils.doInit();
            }
        });
    }

    private static void doInit() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
            DriverManager.getDrivers();
            Toolkit.getDefaultToolkit();
            ImageIO.getCacheDirectory();
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private MuleClassLoaderUtils() {
    }

    public static MuleClassLoader createMuleClassLoader(URL[] urls, ClassLoader parent) {
        return new MuleClassLoader(urls, parent);
    }

    public static <T> T runWithProjectClassPath(final Callable<T> callable, final IMuleProject muleProject, final ClassLoader parentClassloader) {
        MuleClassLoaderUtils.init();
        return (T)SilentRunner.run((Callable)new Callable<T>(){

            @Override
            public T call() throws Exception {
                ProjectClassPath classPath = new ProjectClassPathProvider().getClassPath(muleProject);
                MuleClassLoader createMuleClassLoader = MuleClassLoaderUtils.createMuleClassLoader(classPath.getUrls(), parentClassloader);
                createMuleClassLoader.setLibraryPaths(classPath.getNativeLibraryPaths());
                Thread currentThread = Thread.currentThread();
                ClassLoader old = currentThread.getContextClassLoader();
                currentThread.setContextClassLoader(createMuleClassLoader);
                try {
                    Object v = callable.call();
                    return v;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                    MuleClassLoaderUtils.dispose(createMuleClassLoader);
                }
            }
        }, null);
    }

    public static <T> T runWithFullClassPath(Callable<T> callable, IMuleProject muleProject, ClassLoader parentClassloader) {
        return MuleClassLoaderUtils.runWithFullClassPath(callable, muleProject, parentClassloader, null);
    }

    public static <T> T runWithFullClassPath(final Callable<T> callable, final IMuleProject muleProject, final ClassLoader parentClassloader, T defaultValue) {
        MuleClassLoaderUtils.init();
        return (T)SilentRunner.run((Callable)new Callable<T>(){

            @Override
            public T call() throws Exception {
                ProjectClassPathProvider projectClassPathProvider = new ProjectClassPathProvider();
                MuleClassLoader runtimeServer = MuleCorePlugin.getInstance().getMuleRuntimeClassloaderCache().get(muleProject, parentClassloader);
                URL[] urls = projectClassPathProvider.getClassPath(muleProject).getUrls();
                MuleClassLoader createMuleClassLoader = MuleClassLoaderUtils.createMuleClassLoader(urls, runtimeServer);
                Thread currentThread = Thread.currentThread();
                ClassLoader old = currentThread.getContextClassLoader();
                currentThread.setContextClassLoader(createMuleClassLoader);
                try {
                    Object v = callable.call();
                    return v;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                    MuleClassLoaderUtils.dispose(createMuleClassLoader);
                }
            }
        }, defaultValue);
    }

    public static void dispose(ClassLoader classLoader) {
        try {
            Authenticator currentAuthenticator;
            if (classLoader instanceof MuleClassLoader) {
                ((MuleClassLoader)classLoader).shutdown();
            }
            if ((currentAuthenticator = CoreUtils.getCurrentAuthenticator()) != STUDIO_AUTHENTICATOR) {
                MuleCorePlugin.logWarning("Authenticator was changed to " + String.valueOf(currentAuthenticator != null ? currentAuthenticator.getClass() : "null") + ". Restoring default authenticator to " + String.valueOf(STUDIO_AUTHENTICATOR != null ? STUDIO_AUTHENTICATOR.getClass() : "null"));
                Authenticator.setDefault(STUDIO_AUTHENTICATOR);
            }
        }
        catch (Throwable t) {
            MuleCorePlugin.logWarning("There were problems disposing the Mule Classloader", t);
        }
    }
}

