/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.classloader;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaModelException;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.classloader.MuleClassLoader;
import org.mule.tooling.core.classloader.MuleClassLoaderUtils;
import org.mule.tooling.core.classloader.ProjectClassPathProvider;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;

public class MuleClassLoaderCache {
    private Table<String, ClassLoader, MuleClassLoader> classloaderCache = HashBasedTable.create();

    public MuleClassLoader get(IMuleProject muleProject, ClassLoader parentClassLoader) {
        String requestedRuntimeId = muleProject.getRuntimeId();
        return this.get(requestedRuntimeId, parentClassLoader);
    }

    private MuleClassLoader get(String runtimeId, ClassLoader parentClassLoader) {
        String actualRuntimeId = this.getRuntimeId(runtimeId);
        if (!this.classloaderCache.contains((Object)actualRuntimeId, (Object)parentClassLoader)) {
            this.classloaderCache.put((Object)actualRuntimeId, (Object)parentClassLoader, (Object)MuleClassLoaderUtils.createMuleClassLoader(this.getServerClassPath(runtimeId), parentClassLoader));
        }
        return (MuleClassLoader)this.classloaderCache.get((Object)actualRuntimeId, (Object)parentClassLoader);
    }

    private String getRuntimeId(String requestedRuntimeId) {
        String actualRuntimeId = "";
        if (CoreUtils.isServerAvailable(requestedRuntimeId)) {
            actualRuntimeId = requestedRuntimeId;
        } else {
            actualRuntimeId = CoreUtils.getDefaultServerRuntimeId();
            MuleCorePlugin.logWarning("Server version: " + requestedRuntimeId + " not found. Default Server version " + actualRuntimeId + " used.", null);
        }
        return actualRuntimeId;
    }

    private URL[] getServerClassPath(String runtimeId) {
        try {
            Set<URL> serverClassPath = new ProjectClassPathProvider().getServerClassPath(runtimeId);
            return serverClassPath.toArray(new URL[serverClassPath.size()]);
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }
}

