/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.classloader;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Timer;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.io.FileUtils;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.utils.StudioFileUtils;

public class MuleClassLoader
extends URLClassLoader {
    private String[] libraryPaths = null;
    private Collection<String> loadedTempNativeLibries = null;
    private File tempDir = StudioFileUtils.getTempDirectory();

    public MuleClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.loadedTempNativeLibries = new Vector<String>();
        if (this.tempDir == null) {
            this.tempDir = new File("");
        }
    }

    public void setLibraryPaths(String[] libraryPaths) {
        this.libraryPaths = libraryPaths;
    }

    private File getTemporaryLibraryLocation(String nativeLibName) {
        String tempNativeLibName = System.currentTimeMillis() + "-" + nativeLibName;
        return new File(this.tempDir, tempNativeLibName);
    }

    public String findNativeLibrary(String name) {
        return this.findLibrary(name);
    }

    @Override
    protected String findLibrary(String name) {
        String parentResolvedPath = super.findLibrary(name);
        if (parentResolvedPath == null && this.libraryPaths != null) {
            String[] stringArray = this.libraryPaths;
            int n = this.libraryPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String libraryPath = stringArray[n2];
                String nativeLibName = System.mapLibraryName(name);
                File library = new File(libraryPath, nativeLibName);
                if (!library.exists() && nativeLibName.endsWith(".dylib")) {
                    nativeLibName = nativeLibName.replace("dylib", "jnilib");
                    library = new File(libraryPath, nativeLibName);
                }
                if (library.exists()) {
                    File tempLibrary = this.getTemporaryLibraryLocation(nativeLibName);
                    try {
                        FileUtils.copyFile((File)library, (File)tempLibrary);
                        this.loadedTempNativeLibries.add(tempLibrary.getAbsolutePath());
                        parentResolvedPath = tempLibrary.getAbsolutePath();
                    }
                    catch (Exception ex) {
                        MuleCorePlugin.logWarning("Cannot copy native library " + this.fileToString(library) + " to " + this.fileToString(tempLibrary), ex);
                        parentResolvedPath = library.getAbsolutePath();
                    }
                    break;
                }
                ++n2;
            }
        }
        return parentResolvedPath;
    }

    private String fileToString(File f) {
        if (f != null) {
            return f.getAbsolutePath();
        }
        return "null";
    }

    public void shutdown() {
        if (this.loadedTempNativeLibries != null) {
            for (String tempNativeLib : this.loadedTempNativeLibries) {
                new File(tempNativeLib).delete();
            }
            this.loadedTempNativeLibries.clear();
            this.loadedTempNativeLibries = null;
        }
        if (this.libraryPaths != null) {
            int i = 0;
            while (i < this.libraryPaths.length) {
                this.libraryPaths[i] = null;
                ++i;
            }
            this.libraryPaths = null;
        }
        this.leakPreventionForMule();
        this.leakPreventionForMBeans();
        this.leakPreventionForJdbc();
        this.leakPreventionForHttpClient();
        this.leakPreventionForResourceBundles();
    }

    private void leakPreventionForMule() {
        try {
            Class<?> logFactory = this.findClass("org.apache.commons.logging.LogFactory");
            if (logFactory != null) {
                logFactory.getMethod("release", ClassLoader.class).invoke(null, this);
            }
        }
        catch (Exception exception) {
        }
        catch (VerifyError verifyError) {}
    }

    private void leakPreventionForJdbc() {
        HashSet<String> maliciousThreads = new HashSet<String>();
        maliciousThreads.add("Abandoned connection cleanup thread");
        maliciousThreads.add("Mule.log.slf4j.ref.handler");
        maliciousThreads.add("Mule.log.clogging.ref.handler");
        maliciousThreads.add("MuleServer.01");
        this.leakPreventionForJdbcDrivers();
        this.leakPreventionForMySQL();
        for (String threadName : maliciousThreads) {
            this.leakPreventionForThreads(threadName);
        }
    }

    private void leakPreventionForMySQL() {
        try {
            Class<?> abandonedConnectionCleanupThreadClass = Class.forName("com.mysql.jdbc.AbandonedConnectionCleanupThread", false, this);
            if (this.hasDeclaredMethod(abandonedConnectionCleanupThreadClass, "shutdown", new Class[0])) {
                Method m = abandonedConnectionCleanupThreadClass.getDeclaredMethod("shutdown", new Class[0]);
                m.invoke(null, new Object[0]);
            }
        }
        catch (Exception exception) {}
        try {
            Field f;
            Class<?> connectionImplClass = Class.forName("com.mysql.jdbc.ConnectionImpl", false, this);
            if (this.hasDeclaredField(connectionImplClass, "cancelTimer") && Modifier.isStatic((f = connectionImplClass.getDeclaredField("cancelTimer")).getModifiers())) {
                f.setAccessible(true);
                Timer timer = (Timer)f.get(null);
                if (timer != null) {
                    timer.cancel();
                }
            }
        }
        catch (Exception exception) {}
    }

    private void leakPreventionForJdbcDrivers() {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            try {
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException ex) {
                MuleCorePlugin.logWarning(String.format("Error deregistering driver %s", driver), ex);
            }
        }
        try {
            Object vector;
            Class<?> driverManagerClass = Class.forName("java.sql.DriverManager", false, this);
            if (this.hasDeclaredField(driverManagerClass, "writeDrivers")) {
                Field writeDrivers = driverManagerClass.getDeclaredField("writeDrivers");
                writeDrivers.setAccessible(true);
                vector = writeDrivers.get(null);
                ((Vector)vector).clear();
                vector = null;
            }
            if (this.hasDeclaredField(driverManagerClass, "readDrivers")) {
                Field readDrivers = driverManagerClass.getDeclaredField("readDrivers");
                readDrivers.setAccessible(true);
                vector = readDrivers.get(null);
                ((Vector)vector).clear();
                vector = null;
            }
            if (this.hasDeclaredField(driverManagerClass, "registeredDrivers")) {
                Field registeredDrivers = driverManagerClass.getDeclaredField("registeredDrivers");
                registeredDrivers.setAccessible(true);
                Object list = registeredDrivers.get(null);
                ((CopyOnWriteArrayList)list).clear();
                list = null;
            }
        }
        catch (Exception exception) {}
    }

    private boolean hasDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredMethod(methodName, parameterTypes) != null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    private boolean hasDeclaredField(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName) != null;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return false;
        }
    }

    protected void leakPreventionForMBeans() {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            Set<ObjectName> allMBeanNames = mBeanServer.queryNames(new ObjectName("*:*"), null);
            for (ObjectName objectName : allMBeanNames) {
                try {
                    ClassLoader mBeanClassLoader = mBeanServer.getClassLoaderFor(objectName);
                    if (mBeanClassLoader != this) continue;
                    mBeanServer.unregisterMBean(objectName);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leakPreventionForThreads(String threadName) {
        try {
            Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
            for (Thread t : threadSet) {
                if (t == null || this != t.getContextClassLoader() || !t.getName().contains(threadName)) continue;
                Thread thread = t;
                synchronized (thread) {
                    t.setContextClassLoader(null);
                    t.stop();
                }
            }
        }
        catch (Exception ex) {
            MuleCorePlugin.logWarning("Potential Class Loader leak. Not able to free classloader GC roots.", ex);
        }
    }

    private void leakPreventionForHttpClient() {
        try {
            Class<?> httpClientClass = Class.forName("sun.net.www.http.HttpClient");
            Class<?> keepAliveTimerClass = Class.forName("sun.net.www.http.KeepAliveCache");
            if (httpClientClass != null && keepAliveTimerClass != null) {
                Field kac = httpClientClass.getDeclaredField("kac");
                kac.setAccessible(true);
                Field keepAliveTimer = keepAliveTimerClass.getDeclaredField("keepAliveTimer");
                keepAliveTimer.setAccessible(true);
                Object keepAliveCacheInstance = kac.get(null);
                Thread t = (Thread)keepAliveTimer.get(keepAliveCacheInstance);
                if (t != null) {
                    t.interrupt();
                    keepAliveTimer.set(keepAliveCacheInstance, null);
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception ex) {
            MuleCorePlugin.logWarning("Potential Class Loader leak. Not able to free classloader GC roots.", ex);
        }
    }

    private void leakPreventionForResourceBundles() {
        try {
            Field cacheListField = ResourceBundle.class.getDeclaredField("cacheList");
            cacheListField.setAccessible(true);
            Map cacheList = (Map)cacheListField.get(null);
            Set keys = cacheList.keySet();
            Field loaderRefField = null;
            Iterator keysIter = keys.iterator();
            while (keysIter.hasNext()) {
                Object key = keysIter.next();
                if (loaderRefField == null) {
                    loaderRefField = key.getClass().getDeclaredField("loaderRef");
                    loaderRefField.setAccessible(true);
                }
                WeakReference loaderRef = (WeakReference)loaderRefField.get(key);
                ClassLoader loader = (ClassLoader)loaderRef.get();
                while (loader != null && loader != this) {
                    loader = loader.getParent();
                }
                if (loader == null) continue;
                keysIter.remove();
            }
        }
        catch (Exception exception) {}
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

