/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.classloader;

import java.util.concurrent.Callable;

public class ClassLoaderUtils {
    private ClassLoaderUtils() {
    }

    public static <T> T runIn(Callable<T> callback, ClassLoader classloader) throws Exception {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classloader);
            T t = callback.call();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }
}

